/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs7.DigestInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class MacData
implements ASN1Value {
    private DigestInfo mac;
    private OCTET_STRING macSalt;
    private INTEGER macIterationCount;
    private static final int DEFAULT_ITERATIONS = 1;
    private static final int SALT_LENGTH = 20;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public DigestInfo getMac() {
        return this.mac;
    }

    public OCTET_STRING getMacSalt() {
        return this.macSalt;
    }

    public INTEGER getMacIterationCount() {
        return this.macIterationCount;
    }

    public MacData() {
    }

    public MacData(DigestInfo mac, OCTET_STRING macSalt, INTEGER macIterationCount) {
        if (mac == null || macSalt == null || macIterationCount == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.mac = mac;
        this.macSalt = macSalt;
        this.macIterationCount = macIterationCount;
    }

    public MacData(Password password, byte[] macSalt, int iterations, byte[] toBeMACed) throws CryptoManager.NotInitializedException, DigestException, TokenException, CharConversionException {
        try {
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken token = cm.getInternalCryptoToken();
            if (macSalt == null) {
                JSSSecureRandom rand = cm.createPseudoRandomNumberGenerator();
                macSalt = new byte[20];
                rand.nextBytes(macSalt);
            }
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.PBA_SHA1_HMAC);
            PBEKeyGenParams params = new PBEKeyGenParams(password, macSalt, iterations);
            kg.setCharToByteConverter(new PasswordConverter());
            kg.initialize(params);
            SymmetricKey key = kg.generate();
            JSSMessageDigest digest = token.getDigestContext(HMACAlgorithm.SHA1);
            digest.initHMAC(key);
            byte[] digestBytes = digest.digest(toBeMACed);
            AlgorithmIdentifier algID = new AlgorithmIdentifier(DigestAlgorithm.SHA1.toOID());
            this.mac = new DigestInfo(algID, new OCTET_STRING(digestBytes));
            this.macSalt = new OCTET_STRING(macSalt);
            this.macIterationCount = new INTEGER(iterations);
        }
        catch (NoSuchAlgorithmException e) {
            Assert.notReached("SHA-1 HMAC algorithm not found on internal  token (" + e.toString() + ")");
        }
        catch (InvalidAlgorithmParameterException e) {
            Assert.notReached("Invalid PBE algorithm parameters");
        }
        catch (IllegalStateException e) {
            Assert.notReached("IllegalStateException");
        }
        catch (InvalidKeyException e) {
            Assert.notReached("Invalid key exception");
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.mac);
        seq.addElement(this.macSalt);
        if (!this.macIterationCount.equals(new INTEGER(1L))) {
            seq.addElement(this.macIterationCount);
        }
        seq.encode(implicitTag, ostream);
    }

    public static final Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(DigestInfo.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate(), new INTEGER(1L));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new MacData((DigestInfo)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1), (INTEGER)seq.elementAt(2));
        }
    }
}

