/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.AssertionException;
import org.mozilla.jss.util.Password;

public final class SafeBag
implements ASN1Value {
    private OBJECT_IDENTIFIER bagType;
    private ANY bagContent;
    private SET bagAttributes;
    public static final OBJECT_IDENTIFIER PKCS12_VERSION_1 = OBJECT_IDENTIFIER.PKCS12.subBranch(10L);
    public static final OBJECT_IDENTIFIER PKCS12_BAG_IDS = PKCS12_VERSION_1.subBranch(1L);
    public static final OBJECT_IDENTIFIER KEY_BAG = PKCS12_BAG_IDS.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS8_SHROUDED_KEY_BAG = PKCS12_BAG_IDS.subBranch(2L);
    public static final OBJECT_IDENTIFIER CERT_BAG = PKCS12_BAG_IDS.subBranch(3L);
    public static final OBJECT_IDENTIFIER CRL_BAG = PKCS12_BAG_IDS.subBranch(4L);
    public static final OBJECT_IDENTIFIER SECRET_BAG = PKCS12_BAG_IDS.subBranch(5L);
    public static final OBJECT_IDENTIFIER SAFE_CONTENTS_BAG = PKCS12_BAG_IDS.subBranch(6L);
    public static final OBJECT_IDENTIFIER FRIENDLY_NAME = OBJECT_IDENTIFIER.PKCS9.subBranch(20L);
    public static final OBJECT_IDENTIFIER LOCAL_KEY_ID = OBJECT_IDENTIFIER.PKCS9.subBranch(21L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getBagType() {
        return this.bagType;
    }

    public ANY getBagContent() {
        return this.bagContent;
    }

    public ASN1Value getInterpretedBagContent() throws InvalidBERException {
        if (this.bagType.equals(KEY_BAG)) {
            return this.bagContent.decodeWith(PrivateKeyInfo.getTemplate());
        }
        if (this.bagType.equals(PKCS8_SHROUDED_KEY_BAG)) {
            return this.bagContent.decodeWith(EncryptedPrivateKeyInfo.getTemplate());
        }
        if (this.bagType.equals(CERT_BAG)) {
            return this.bagContent.decodeWith(CertBag.getTemplate());
        }
        return this.bagContent;
    }

    public SET getBagAttributes() {
        return this.bagAttributes;
    }

    private SafeBag() {
    }

    public SafeBag(OBJECT_IDENTIFIER bagType, ASN1Value bagContent, SET bagAttributes) {
        if (bagType == null || bagContent == null) {
            throw new IllegalArgumentException("bagType or bagContent is null");
        }
        this.bagType = bagType;
        try {
            if (bagContent instanceof ANY) {
                this.bagContent = (ANY)bagContent;
            } else {
                byte[] encoded = ASN1Util.encode(bagContent);
                this.bagContent = (ANY)ASN1Util.decode(ANY.getTemplate(), encoded);
            }
        }
        catch (InvalidBERException e) {
            Assert.notReached("failed to convert ASN1Value to ANY");
        }
        this.bagAttributes = bagAttributes;
    }

    public static SafeBag createCertBag(byte[] cert, String friendlyName) throws DigestException, NoSuchAlgorithmException, InvalidBERException {
        return SafeBag.createCertBag(cert, friendlyName, SafeBag.getLocalKeyIDFromCert(cert));
    }

    public static SafeBag createCertBag(byte[] cert, String friendlyName, byte[] localKeyID) throws InvalidBERException {
        try {
            CertBag cb = new CertBag(CertBag.X509_CERT_TYPE, new ANY(cert));
            SET attributes = new SET();
            attributes.addElement(new Attribute(FRIENDLY_NAME, new BMPString(friendlyName)));
            attributes.addElement(new Attribute(LOCAL_KEY_ID, new OCTET_STRING(localKeyID)));
            return new SafeBag(CERT_BAG, cb, attributes);
        }
        catch (CharConversionException e) {
            throw new AssertionException("CharConversionException converting Unicode to BMPString");
        }
    }

    public static final byte[] getLocalKeyIDFromCert(byte[] derCert) throws DigestException, NoSuchAlgorithmException {
        MessageDigest digester = MessageDigest.getInstance("SHA-1");
        return digester.digest(derCert);
    }

    public static SafeBag createEncryptedPrivateKeyBag(PrivateKeyInfo privk, String friendlyName, byte[] localKeyID, Password password) throws CryptoManager.NotInitializedException, TokenException {
        try {
            PBEAlgorithm pbeAlg = PBEAlgorithm.PBE_SHA1_DES3_CBC;
            boolean DEFAULT_ITERATIONS = true;
            byte[] salt = new byte[pbeAlg.getSaltLength()];
            JSSSecureRandom rand = CryptoManager.getInstance().getSecureRNG();
            rand.nextBytes(salt);
            EncryptedPrivateKeyInfo epki = EncryptedPrivateKeyInfo.createPBE(PBEAlgorithm.PBE_SHA1_DES3_CBC, password, salt, 1, new PasswordConverter(), privk);
            SET attributes = new SET();
            attributes.addElement(new Attribute(FRIENDLY_NAME, new BMPString(friendlyName)));
            attributes.addElement(new Attribute(LOCAL_KEY_ID, new OCTET_STRING(localKeyID)));
            return new SafeBag(PKCS8_SHROUDED_KEY_BAG, epki, attributes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionException("Unable to find PBE algorithm: " + e);
        }
        catch (InvalidKeyException e) {
            throw new AssertionException("InvalidKeyException while creating EncryptedContentInfo: " + e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new AssertionException("InvalidAlgorithmParameterException while creating EncryptedContentInfo: " + e);
        }
        catch (CharConversionException e) {
            throw new AssertionException("CharConversionException while creating EncryptedContentInfo: " + e);
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.bagType);
        seq.addElement(new EXPLICIT(new Tag(0L), this.bagContent));
        if (this.bagAttributes != null) {
            seq.addElement(this.bagAttributes);
        }
        seq.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(new EXPLICIT.Template(new Tag(0L), ANY.getTemplate()));
            this.seqt.addOptionalElement(new SET.OF_Template(Attribute.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            try {
                SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
                return new SafeBag((OBJECT_IDENTIFIER)seq.elementAt(0), ((EXPLICIT)seq.elementAt(1)).getContent(), (SET)seq.elementAt(2));
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "SafeBag");
            }
        }
    }
}

