/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class SecretBag
implements ASN1Value {
    private OBJECT_IDENTIFIER secretType;
    private ANY secret;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getSecretType() {
        return this.secretType;
    }

    public ANY getSecret() {
        return this.secret;
    }

    private SecretBag() {
    }

    public SecretBag(OBJECT_IDENTIFIER secretType, ASN1Value secret) {
        if (secretType == null || secret == null) {
            throw new IllegalArgumentException("SecretBag parameter is null");
        }
        this.secretType = secretType;
        if (secret instanceof ANY) {
            this.secret = (ANY)secret;
        } else {
            byte[] encoded = ASN1Util.encode(secret);
            try {
                this.secret = (ANY)ASN1Util.decode(ANY.getTemplate(), encoded);
            }
            catch (InvalidBERException e) {
                Assert.notReached("Failed to convert ASN1Value to ANY");
            }
        }
        this.sequence = new SEQUENCE();
        this.sequence.addElement(secretType);
        this.sequence.addElement(new EXPLICIT(new Tag(0L), this.secret));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(new EXPLICIT.Template(new Tag(0L), ANY.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new SecretBag((OBJECT_IDENTIFIER)seq.elementAt(0), ((EXPLICIT)seq.elementAt(1)).getContent());
        }
    }
}

