/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class DigestedData
implements ASN1Value {
    private INTEGER version;
    private AlgorithmIdentifier digestAlgorithm;
    private ContentInfo contentInfo;
    private OCTET_STRING digest;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public INTEGER getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public OCTET_STRING getDigest() {
        return this.digest;
    }

    private DigestedData() {
    }

    public DigestedData(INTEGER version, AlgorithmIdentifier digestAlgorithm, ContentInfo contentInfo, OCTET_STRING digest) {
        if (version == null || digestAlgorithm == null || contentInfo == null || digest == null) {
            throw new IllegalArgumentException("DigestedData constructor parameter is null");
        }
        this.version = version;
        this.digestAlgorithm = digestAlgorithm;
        this.contentInfo = contentInfo;
        this.digest = digest;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(version);
        this.sequence.addElement(digestAlgorithm);
        this.sequence.addElement(contentInfo);
        this.sequence.addElement(digest);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new DigestedData((INTEGER)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (ContentInfo)seq.elementAt(2), (OCTET_STRING)seq.elementAt(3));
        }
    }
}

