/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class EncryptedContentInfo
implements ASN1Value {
    private OBJECT_IDENTIFIER contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private OCTET_STRING encryptedContent;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();
    static /* synthetic */ Class class$org$mozilla$jss$crypto$IVParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;

    public OBJECT_IDENTIFIER getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedContent() {
        return this.encryptedContent;
    }

    public boolean hasEncryptedContent() {
        return this.encryptedContent != null;
    }

    private EncryptedContentInfo() {
    }

    public EncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier contentEncryptionAlgorithm, OCTET_STRING encryptedContent) {
        this(contentType, contentEncryptionAlgorithm, encryptedContent, false);
    }

    public EncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier contentEncryptionAlgorithm, OCTET_STRING encryptedContent, boolean createHackedCRSCompatibleECI) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedContent = encryptedContent;
        this.sequence.addElement(contentType);
        this.sequence.addElement(contentEncryptionAlgorithm);
        if (encryptedContent != null) {
            if (createHackedCRSCompatibleECI) {
                this.sequence.addElement(new EXPLICIT(new Tag(0L), encryptedContent));
            } else {
                this.sequence.addElement(new Tag(0L), encryptedContent);
            }
        }
    }

    public static EncryptedContentInfo createCRSCompatibleEncryptedContentInfo(OBJECT_IDENTIFIER contentType, AlgorithmIdentifier contentEncryptionAlgorithm, OCTET_STRING encryptedContent) {
        return new EncryptedContentInfo(contentType, contentEncryptionAlgorithm, encryptedContent, true);
    }

    public static EncryptedContentInfo createPBE(PBEAlgorithm keyGenAlg, Password password, byte[] salt, int iterationCount, KeyGenerator.CharToByteConverter charToByteConverter, byte[] toBeEncrypted) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            if (!(keyGenAlg instanceof PBEAlgorithm)) {
                throw new NoSuchAlgorithmException("Key generation algorithm is not a PBE algorithm");
            }
            PBEAlgorithm pbeAlg = keyGenAlg;
            CryptoManager cman = CryptoManager.getInstance();
            CryptoToken token = cman.getInternalCryptoToken();
            KeyGenerator kg = token.getKeyGenerator(keyGenAlg);
            PBEKeyGenParams pbekgParams = new PBEKeyGenParams(password, salt, iterationCount);
            if (charToByteConverter != null) {
                kg.setCharToByteConverter(charToByteConverter);
            }
            kg.initialize(pbekgParams);
            SymmetricKey key = kg.generate();
            EncryptionAlgorithm encAlg = pbeAlg.getEncryptionAlg();
            AlgorithmParameterSpec params = null;
            if (encAlg.getParameterClass().equals(class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptedContentInfo.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec)) {
                params = new IVParameterSpec(kg.generatePBE_IV());
            } else if (encAlg.getParameterClass().equals(class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = EncryptedContentInfo.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec)) {
                params = new RC2ParameterSpec(key.getStrength(), kg.generatePBE_IV());
            }
            Cipher cipher2 = token.getCipherContext(encAlg);
            cipher2.initEncrypt(key, params);
            byte[] encrypted = cipher2.doFinal(Cipher.pad(toBeEncrypted, encAlg.getBlockSize()));
            PBEParameter pbeParam = new PBEParameter(salt, iterationCount);
            AlgorithmIdentifier encAlgID = new AlgorithmIdentifier(keyGenAlg.toOID(), pbeParam);
            EncryptedContentInfo encCI = new EncryptedContentInfo(ContentInfo.DATA, encAlgID, new OCTET_STRING(encrypted));
            return encCI;
        }
        catch (IllegalBlockSizeException e) {
            Assert.notReached("IllegalBlockSizeException in EncryptedContentInfo.createPBE");
        }
        catch (BadPaddingException e) {
            Assert.notReached("BadPaddingException in EncryptedContentInfo.createPBE");
        }
        return null;
    }

    public byte[] decrypt(Password pass, KeyGenerator.CharToByteConverter charToByteConverter) throws IllegalStateException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidBERException, IOException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException {
        PBEParameter pbeParams;
        if (this.encryptedContent == null) {
            return null;
        }
        AlgorithmIdentifier algid = this.contentEncryptionAlgorithm;
        KeyGenAlgorithm kgAlg = KeyGenAlgorithm.fromOID(algid.getOID());
        if (!(kgAlg instanceof PBEAlgorithm)) {
            throw new NoSuchAlgorithmException("KeyGenAlgorithm is not a PBE algorithm");
        }
        ASN1Value params = algid.getParameters();
        if (params == null) {
            throw new InvalidAlgorithmParameterException("PBE algorithms require parameters");
        }
        if (params instanceof PBEParameter) {
            pbeParams = (PBEParameter)params;
        } else {
            byte[] encodedParams = ASN1Util.encode(params);
            pbeParams = (PBEParameter)ASN1Util.decode(PBEParameter.getTemplate(), encodedParams);
        }
        PBEKeyGenParams kgp = new PBEKeyGenParams(pass, pbeParams.getSalt(), pbeParams.getIterations());
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        KeyGenerator kg = token.getKeyGenerator(kgAlg);
        if (charToByteConverter != null) {
            kg.setCharToByteConverter(charToByteConverter);
        }
        kg.initialize(kgp);
        SymmetricKey key = kg.generate();
        EncryptionAlgorithm encAlg = ((PBEAlgorithm)kgAlg).getEncryptionAlg();
        AlgorithmParameterSpec algParams = null;
        if (encAlg.getParameterClass().equals(class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptedContentInfo.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec)) {
            algParams = new IVParameterSpec(kg.generatePBE_IV());
        } else if (encAlg.getParameterClass().equals(class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = EncryptedContentInfo.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec)) {
            algParams = new RC2ParameterSpec(key.getStrength(), kg.generatePBE_IV());
        }
        Cipher cipher2 = token.getCipherContext(encAlg);
        cipher2.initDecrypt(key, algParams);
        return Cipher.unPad(cipher2.doFinal(this.encryptedContent.toByteArray()));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag tag, OutputStream ostream) throws IOException {
        this.sequence.encode(tag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new OBJECT_IDENTIFIER.Template());
            seqt.addElement(new AlgorithmIdentifier.Template());
            seqt.addOptionalElement(new Tag(0L), new OCTET_STRING.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 3);
            return new EncryptedContentInfo((OBJECT_IDENTIFIER)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2));
        }
    }
}

