/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;

public class EncryptedData
implements ASN1Value {
    private INTEGER version;
    private EncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence;
    public static final INTEGER DEFAULT_VERSION = new INTEGER(0L);
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private EncryptedData() {
    }

    public EncryptedData(INTEGER version, EncryptedContentInfo encryptedContentInfo) {
        if (version == null || encryptedContentInfo == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.sequence = new SEQUENCE();
        this.version = version;
        this.sequence.addElement(version);
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement(encryptedContentInfo);
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this(DEFAULT_VERSION, encryptedContentInfo);
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(EncryptedContentInfo.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new EncryptedData((INTEGER)seq.elementAt(0), (EncryptedContentInfo)seq.elementAt(1));
        }
    }
}

