/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.Assert;

public class IssuerAndSerialNumber
implements ASN1Value {
    private Name issuer;
    private INTEGER serialNumber;
    private SEQUENCE sequence;
    static Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    private IssuerAndSerialNumber() {
    }

    public IssuerAndSerialNumber(Name issuer, INTEGER serialNumber) {
        if (issuer == null || serialNumber == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = new SEQUENCE();
        this.issuer = issuer;
        this.sequence.addElement(issuer);
        this.serialNumber = serialNumber;
        this.sequence.addElement(serialNumber);
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(Name.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 2);
            return new IssuerAndSerialNumber((Name)seq.elementAt(0), (INTEGER)seq.elementAt(1));
        }
    }
}

