/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TimeBase;
import org.mozilla.jss.asn1.UTCTime;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

public class CertificateInfo
implements ASN1Value {
    public static final Version v1 = Version.v1;
    public static final Version v2 = Version.v2;
    public static final Version v3 = Version.v3;
    static final int UTCTIME_CUTOFF_YEAR = 2049;
    private Version version = v1;
    private INTEGER serialNumber;
    private AlgorithmIdentifier signatureAlgId;
    private Name issuer;
    private Date notBefore;
    private Date notAfter;
    private Name subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private BIT_STRING issuerUniqueIdentifier;
    private BIT_STRING subjectUniqueIdentifier;
    private SEQUENCE extensions;
    static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public CertificateInfo(Version version, INTEGER serialNumber, AlgorithmIdentifier signatureAlgId, Name issuer, Date notBefore, Date notAfter, Name subject, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.setVersion(version);
        this.setSerialNumber(serialNumber);
        this.setSignatureAlgId(signatureAlgId);
        this.setIssuer(issuer);
        this.setNotBefore(notBefore);
        this.setNotAfter(notAfter);
        this.setSubject(subject);
        this.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.extensions = new SEQUENCE();
    }

    public void setVersion(Version version) {
        this.verifyNotNull(version);
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setSerialNumber(INTEGER serialNumber) {
        this.verifyNotNull(serialNumber);
        this.serialNumber = serialNumber;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public void setSignatureAlgId(AlgorithmIdentifier signatureAlgId) {
        this.verifyNotNull(signatureAlgId);
        this.signatureAlgId = signatureAlgId;
    }

    public AlgorithmIdentifier getSignatureAlgId() {
        return this.signatureAlgId;
    }

    public void setIssuer(Name issuer) {
        this.verifyNotNull(issuer);
        this.issuer = issuer;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public void setNotBefore(Date notBefore) {
        this.verifyNotNull(notBefore);
        this.notBefore = notBefore;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotAfter(Date notAfter) {
        this.verifyNotNull(notAfter);
        this.notAfter = notAfter;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setSubject(Name subject) {
        this.verifyNotNull(subject);
        this.subject = subject;
    }

    public Name getSubject() {
        return this.subject;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.verifyNotNull(subjectPublicKeyInfo);
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public void setSubjectPublicKeyInfo(PublicKey pubk) throws InvalidBERException, IOException {
        this.verifyNotNull(pubk);
        this.setSubjectPublicKeyInfo(new SubjectPublicKeyInfo(pubk));
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setIssuerUniqueIdentifier(BIT_STRING issuerUniqueIdentifier) throws CertificateException {
        if (this.version == v1) {
            throw new CertificateException("issuerUniqueIdentifier cannot be specified for v1 certificate");
        }
        this.verifyNotNull(issuerUniqueIdentifier);
        this.issuerUniqueIdentifier = issuerUniqueIdentifier;
    }

    public boolean hasIssuerUniqueIdentifier() {
        return this.issuerUniqueIdentifier != null;
    }

    public BIT_STRING getIssuerUniqueIdentifier() {
        Assert._assert(this.issuerUniqueIdentifier != null);
        return this.issuerUniqueIdentifier;
    }

    public void setSubjectUniqueIdentifier(BIT_STRING subjectUniqueIdentifier) throws CertificateException {
        if (this.version == v1) {
            throw new CertificateException("subjectUniqueIdentifier cannot be specified for v1 certificate");
        }
        this.verifyNotNull(subjectUniqueIdentifier);
        this.subjectUniqueIdentifier = subjectUniqueIdentifier;
    }

    public boolean hasSubjectUniqueIdentifier() {
        return this.subjectUniqueIdentifier != null;
    }

    public BIT_STRING getSubjectUniqueIdentifier() {
        Assert._assert(this.subjectUniqueIdentifier != null);
        return this.subjectUniqueIdentifier;
    }

    public boolean hasExtensions() {
        return this.extensions.size() > 0;
    }

    public SEQUENCE getExtensions() {
        return this.extensions;
    }

    public boolean isExtensionPresent(OBJECT_IDENTIFIER oid) {
        return this.getExtension(oid) != null;
    }

    public Extension getExtension(OBJECT_IDENTIFIER oid) {
        int numExtensions = this.extensions.size();
        for (int i = 0; i < numExtensions; ++i) {
            Extension ext = (Extension)this.extensions.elementAt(i);
            if (!oid.equals(ext.getExtnId())) continue;
            return ext;
        }
        return null;
    }

    public void setExtensions(SEQUENCE extensions) throws CertificateException {
        if (this.version != v3) {
            throw new CertificateException("extensions can only be added to v3 certificates");
        }
        int size = extensions.size();
        for (int i = 0; i < size; ++i) {
            Assert._assert(extensions.elementAt(i) instanceof Extension);
        }
        this.verifyNotNull(extensions);
        this.extensions = extensions;
    }

    public void addExtension(Extension extension) throws CertificateException {
        if (this.version != v3) {
            throw new CertificateException("extensions can only be added to v3 certificates");
        }
        this.extensions.addElement(extension);
    }

    private void verifyNotNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        if (this.version != v1) {
            seq.addElement(new EXPLICIT(new Tag(0L), new INTEGER(this.version.getNumber())));
        }
        seq.addElement(this.serialNumber);
        seq.addElement(this.signatureAlgId);
        seq.addElement(this.issuer);
        SEQUENCE validity = new SEQUENCE();
        validity.addElement(CertificateInfo.encodeValidityDate(this.notBefore));
        validity.addElement(CertificateInfo.encodeValidityDate(this.notAfter));
        seq.addElement(validity);
        seq.addElement(this.subject);
        seq.addElement(this.subjectPublicKeyInfo);
        if (this.issuerUniqueIdentifier != null) {
            seq.addElement(new Tag(1L), this.issuerUniqueIdentifier);
        }
        if (this.subjectUniqueIdentifier != null) {
            seq.addElement(new Tag(2L), this.subjectUniqueIdentifier);
        }
        if (this.extensions.size() > 0) {
            seq.addElement(new EXPLICIT(new Tag(3L), this.extensions));
        }
        seq.encode(implicitTag, ostream);
    }

    private static ASN1Value encodeValidityDate(Date d) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(d);
        if (cal.get(1) <= 2049) {
            return new UTCTime(d);
        }
        return new GeneralizedTime(d);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public void print(PrintStream ps) throws IOException, InvalidBERException {
        ps.println("CertificateInfo:");
        ps.println("Version: " + this.version);
        ps.println("Serial Number: " + this.serialNumber);
        ps.println("Sig OID: " + this.signatureAlgId.getOID());
        ps.println("Issuer: " + this.issuer.getRFC1485());
        ps.println("Not Before: " + this.notBefore);
        ps.println("Not After: " + this.notAfter);
        ps.println("Subject: " + this.subject.getRFC1485());
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            EXPLICIT.Template versionTemp = EXPLICIT.getTemplate(new Tag(0L), INTEGER.getTemplate());
            EXPLICIT defVersion = new EXPLICIT(new Tag(0L), new INTEGER(v1.getNumber()));
            this.seqt.addElement(versionTemp, defVersion);
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(Name.getTemplate());
            SEQUENCE.Template validity = new SEQUENCE.Template();
            CHOICE.Template timeChoice = CHOICE.getTemplate();
            timeChoice.addElement(UTCTime.getTemplate());
            timeChoice.addElement(GeneralizedTime.getTemplate());
            validity.addElement(timeChoice);
            validity.addElement(timeChoice);
            this.seqt.addElement(validity);
            this.seqt.addElement(Name.getTemplate());
            this.seqt.addElement(SubjectPublicKeyInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), BIT_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(2L), BIT_STRING.getTemplate());
            SEQUENCE.OF_Template extnTemp = new SEQUENCE.OF_Template(Extension.getTemplate());
            this.seqt.addOptionalElement(new EXPLICIT.Template(new Tag(3L), extnTemp));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            try {
                SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
                EXPLICIT exp = (EXPLICIT)seq.elementAt(0);
                Version version = Version.fromInt(((INTEGER)exp.getContent()).intValue());
                SEQUENCE validity = (SEQUENCE)seq.elementAt(4);
                CHOICE choice = (CHOICE)validity.elementAt(0);
                Date notBefore = ((TimeBase)choice.getValue()).toDate();
                choice = (CHOICE)validity.elementAt(1);
                Date notAfter = ((TimeBase)choice.getValue()).toDate();
                CertificateInfo cinfo = new CertificateInfo(version, (INTEGER)seq.elementAt(1), (AlgorithmIdentifier)seq.elementAt(2), (Name)seq.elementAt(3), notBefore, notAfter, (Name)seq.elementAt(5), (SubjectPublicKeyInfo)seq.elementAt(6));
                if (seq.elementAt(7) != null) {
                    cinfo.setIssuerUniqueIdentifier((BIT_STRING)seq.elementAt(7));
                }
                if (seq.elementAt(8) != null) {
                    cinfo.setSubjectUniqueIdentifier((BIT_STRING)seq.elementAt(8));
                }
                if (seq.elementAt(9) != null) {
                    exp = (EXPLICIT)seq.elementAt(9);
                    cinfo.setExtensions((SEQUENCE)exp.getContent());
                }
                return cinfo;
            }
            catch (CertificateException e) {
                throw new InvalidBERException(e.getMessage());
            }
        }
    }

    public static class Version {
        int versionNumber;
        String string;
        public static final Version v1 = new Version(0, "v1");
        public static final Version v2 = new Version(1, "v2");
        public static final Version v3 = new Version(2, "v3");

        private Version() {
        }

        private Version(int vers, String string) {
            this.versionNumber = vers;
            this.string = string;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Version)) {
                return false;
            }
            return ((Version)obj).versionNumber == this.versionNumber;
        }

        public int getNumber() {
            return this.versionNumber;
        }

        public static Version fromInt(int versionNum) throws InvalidBERException {
            if (versionNum == 0) {
                return v1;
            }
            if (versionNum == 1) {
                return v2;
            }
            if (versionNum == 2) {
                return v3;
            }
            throw new InvalidBERException("Unrecognized version number");
        }

        public String toString() {
            return this.string;
        }
    }
}

