/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class CMCCertId
implements ASN1Value {
    private SEQUENCE issuer;
    private INTEGER serial;
    private BIT_STRING issuerUID;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public SEQUENCE getIssuer() {
        return this.issuer;
    }

    public INTEGER getSerial() {
        return this.serial;
    }

    public BIT_STRING getIssuerUID() {
        return this.issuerUID;
    }

    private CMCCertId() {
    }

    public CMCCertId(SEQUENCE issuer, INTEGER serial, BIT_STRING issuerUID) {
        if (issuer == null || serial == null) {
            throw new IllegalArgumentException("parameter to CMCCertId constructor is null");
        }
        if (issuer.size() == 0) {
            throw new IllegalArgumentException("issuer parameter to CMCCertId constructor is empty");
        }
        this.sequence = new SEQUENCE();
        this.issuer = issuer;
        this.sequence.addElement(issuer);
        this.serial = serial;
        this.sequence.addElement(serial);
        if (issuerUID != null) {
            this.sequence.addElement(issuerUID);
        }
    }

    public CMCCertId(ANY issuer, INTEGER serial, BIT_STRING issuerUID) {
        if (issuer == null || serial == null) {
            throw new IllegalArgumentException("parameter to CMCCertId constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuer = new SEQUENCE();
        this.issuer.addElement(issuer);
        this.sequence.addElement(this.issuer);
        this.serial = serial;
        this.sequence.addElement(serial);
        if (issuerUID != null) {
            this.sequence.addElement(issuerUID);
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new CMCCertId((SEQUENCE)seq.elementAt(0), (INTEGER)seq.elementAt(1), (BIT_STRING)seq.elementAt(2));
        }
    }
}

