/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class LraPopWitness
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private INTEGER pkiDataBodyid;
    private SEQUENCE bodyIds;
    private SEQUENCE sequence;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private LraPopWitness() {
    }

    public LraPopWitness(INTEGER pkiDataBodyid, SEQUENCE bodyIds) {
        if (pkiDataBodyid == null || bodyIds == null) {
            throw new IllegalArgumentException("parameter to LraPopWitness constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.pkiDataBodyid = pkiDataBodyid;
        this.sequence.addElement(pkiDataBodyid);
        this.bodyIds = bodyIds;
        this.sequence.addElement(bodyIds);
    }

    public void addBodyPartId(int id) {
        INTEGER id1 = new INTEGER(id);
        Assert._assert(id1.compareTo(BODYIDMAX) <= 0);
        this.bodyIds.addElement(id1);
    }

    public INTEGER getPKIDataBodyid() {
        return this.pkiDataBodyid;
    }

    public SEQUENCE getBodyIds() {
        return this.bodyIds;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SEQUENCE.OF_Template(INTEGER.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new LraPopWitness((INTEGER)seq.elementAt(0), (SEQUENCE)seq.elementAt(1));
        }
    }
}

