/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class OtherMsg
implements ASN1Value {
    private INTEGER bodyPartID;
    private OBJECT_IDENTIFIER otherMsgType;
    private ANY otherMsgValue;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public OBJECT_IDENTIFIER getOtherMsgType() {
        return this.otherMsgType;
    }

    public ANY getOtherMsgValue() {
        return this.otherMsgValue;
    }

    private OtherMsg() {
    }

    public OtherMsg(INTEGER bodyPartID, OBJECT_IDENTIFIER otherMsgType, ANY otherMsgValue) {
        if (bodyPartID == null || otherMsgType == null || otherMsgValue == null) {
            throw new IllegalArgumentException("parameter to OtherMsg constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.bodyPartID = bodyPartID;
        this.sequence.addElement(bodyPartID);
        this.otherMsgType = otherMsgType;
        this.sequence.addElement(otherMsgType);
        this.otherMsgValue = otherMsgValue;
        this.sequence.addElement(otherMsgValue);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(ANY.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new OtherMsg((INTEGER)seq.elementAt(0), (OBJECT_IDENTIFIER)seq.elementAt(1), (ANY)seq.elementAt(2));
        }
    }
}

