/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.util.Assert;

public class PKIData
implements ASN1Value {
    private SEQUENCE sequence;
    private SEQUENCE controlSequence;
    private SEQUENCE reqSequence;
    private SEQUENCE cmsSequence;
    private SEQUENCE otherMsgSequence;
    static Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private PKIData() {
    }

    public PKIData(SEQUENCE controlSequence, SEQUENCE reqSequence, SEQUENCE cmsSequence, SEQUENCE otherMsgSequence) {
        this.sequence = new SEQUENCE();
        this.controlSequence = controlSequence;
        this.sequence.addElement(controlSequence);
        this.reqSequence = reqSequence;
        this.sequence.addElement(reqSequence);
        this.cmsSequence = cmsSequence;
        this.sequence.addElement(cmsSequence);
        this.otherMsgSequence = otherMsgSequence;
        this.sequence.addElement(otherMsgSequence);
    }

    public SEQUENCE getControlSequence() {
        return this.controlSequence;
    }

    public SEQUENCE getReqSequence() {
        return this.reqSequence;
    }

    public SEQUENCE getCmsSequence() {
        return this.cmsSequence;
    }

    public SEQUENCE getOtherMsgSequence() {
        return this.otherMsgSequence;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(TaggedAttribute.getTemplate()));
            this.seqt.addElement(new SEQUENCE.OF_Template(TaggedRequest.getTemplate()));
            this.seqt.addElement(new SEQUENCE.OF_Template(new ANY.Template()));
            this.seqt.addElement(new SEQUENCE.OF_Template(new ANY.Template()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 4);
            return new PKIData((SEQUENCE)seq.elementAt(0), (SEQUENCE)seq.elementAt(1), (SEQUENCE)seq.elementAt(2), (SEQUENCE)seq.elementAt(3));
        }
    }
}

