/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs10.CertificationRequest;
import org.mozilla.jss.util.Assert;

public class TaggedCertificationRequest
implements ASN1Value {
    public static final INTEGER BODYIDMAX = new INTEGER("4294967295");
    private SEQUENCE sequence;
    private INTEGER bodyPartID;
    private CertificationRequest certificationRequest;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private TaggedCertificationRequest() {
    }

    public TaggedCertificationRequest(INTEGER bodyPartID, CertificationRequest certificationRequest) {
        this.sequence = new SEQUENCE();
        Assert._assert(bodyPartID.compareTo(BODYIDMAX) <= 0);
        this.bodyPartID = bodyPartID;
        this.sequence.addElement(bodyPartID);
        this.certificationRequest = certificationRequest;
        this.sequence.addElement(certificationRequest);
    }

    public CertificationRequest getCertificationRequest() {
        return this.certificationRequest;
    }

    public INTEGER getBodyPartID() {
        return this.bodyPartID;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(CertificationRequest.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            Assert._assert(seq.size() == 2);
            return new TaggedCertificationRequest((INTEGER)seq.elementAt(0), (CertificationRequest)seq.elementAt(1));
        }
    }
}

