/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmmf.CertOrEncCert;
import org.mozilla.jss.pkix.cmmf.CertResponse;
import org.mozilla.jss.pkix.cmmf.CertifiedKeyPair;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;

public class CertRepContent
implements ASN1Value {
    private byte[][] caPubs;
    private SEQUENCE response;
    public static final Tag TAG = SEQUENCE.TAG;

    private CertRepContent() {
    }

    public CertRepContent(byte[][] caPubs, SEQUENCE response) {
        this.caPubs = caPubs;
        this.response = response;
    }

    public CertRepContent(byte[][] caPubs) {
        this.caPubs = caPubs;
        this.response = new SEQUENCE();
    }

    public CertRepContent(SEQUENCE response) {
        this.caPubs = null;
        this.response = response;
    }

    public void addCertResponse(CertResponse resp) {
        this.response.addElement(resp);
    }

    public byte[][] getCaPubs() {
        return this.caPubs;
    }

    public SEQUENCE getResponse() {
        return this.response;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE encoding = new SEQUENCE();
        if (this.caPubs != null) {
            SEQUENCE certs = new SEQUENCE();
            for (int i = 0; i < this.caPubs.length; ++i) {
                certs.addElement(new ANY(SEQUENCE.TAG, this.caPubs[i]));
            }
            encoding.addElement(new Tag(1L), certs);
        }
        encoding.addElement(this.response);
        encoding.encode(implicitTag, ostream);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 2) {
                System.out.println("Usage: CertRepContent <certfile> <outputfile>");
                System.out.println("certfile should contain a DER-encoded X.509 certificate");
                System.exit(-1);
            }
            FileInputStream certfile = new FileInputStream(argv[0]);
            FileOutputStream fos = new FileOutputStream(argv[1]);
            byte[][] certs = new byte[2][];
            certs[0] = new byte[certfile.available()];
            certfile.read(certs[0]);
            certs[1] = certs[0];
            PKIStatusInfo status = new PKIStatusInfo(2, 0x30000000);
            status.addFreeText("And your mother dresses you funny");
            status.addFreeText("so there");
            CertifiedKeyPair ckp = new CertifiedKeyPair(new CertOrEncCert(certs[0]));
            CertResponse resp = new CertResponse(new INTEGER(54L), status, ckp);
            CertRepContent content = new CertRepContent(certs);
            content.addCertResponse(resp);
            content.encode(fos);
            System.out.println("Success!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

