/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class IssuerAndSubject
implements ASN1Value {
    private ANY issuer;
    private ANY subject;
    private INTEGER certReqId;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ANY getIssuer() {
        return this.issuer;
    }

    public ANY getSubject() {
        return this.subject;
    }

    public INTEGER getCertReqId() {
        return this.certReqId;
    }

    private IssuerAndSubject() {
    }

    public IssuerAndSubject(ANY issuer, ANY subject, INTEGER certReqId) {
        if (issuer == null || subject == null) {
            throw new IllegalArgumentException("parameter to IssuerAndSubject constructor is null");
        }
        this.sequence = new SEQUENCE();
        this.issuer = issuer;
        this.sequence.addElement(issuer);
        this.subject = subject;
        this.sequence.addElement(subject);
        this.certReqId = certReqId;
        this.sequence.addElement(certReqId);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addElement(ANY.getTemplate());
            this.seqt.addOptionalElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new IssuerAndSubject((ANY)seq.elementAt(0), (ANY)seq.elementAt(1), (INTEGER)seq.elementAt(2));
        }
    }
}

