/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmmf.PKIStatusInfo;
import org.mozilla.jss.pkix.crmf.CertId;

public class RevRepContent
implements ASN1Value {
    private SEQUENCE status;
    private SEQUENCE revCerts;
    private SEQUENCE crls;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public SEQUENCE getStatus() {
        return this.status;
    }

    public SEQUENCE getRevCerts() {
        return this.revCerts;
    }

    public SEQUENCE getCrls() {
        return this.crls;
    }

    private RevRepContent() {
    }

    public RevRepContent(SEQUENCE status, SEQUENCE revCerts, SEQUENCE crls) {
        this.sequence = new SEQUENCE();
        this.status = status;
        this.sequence.addElement(status);
        this.revCerts = revCerts;
        this.sequence.addElement(Tag.get(0L), revCerts);
        this.crls = crls;
        this.sequence.addElement(Tag.get(1L), crls);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(new SEQUENCE.OF_Template(PKIStatusInfo.getTemplate()));
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(CertId.getTemplate()));
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(ANY.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new RevRepContent((SEQUENCE)seq.elementAt(0), (SEQUENCE)seq.elementAt(1), (SEQUENCE)seq.elementAt(2));
        }
    }
}

