/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cms.EncryptedContentInfo;
import org.mozilla.jss.pkix.cms.RecipientInfo;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class SignedAndEnvelopedData
implements ASN1Value {
    private INTEGER version;
    private SET recipientInfos;
    private SET digestAlgorithms;
    private EncryptedContentInfo encryptedContentInfo;
    private SET certificates;
    private SET crls;
    private SET signerInfos;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;

    public INTEGER getVersion() {
        return this.version;
    }

    public SET getRecipientInfos() {
        return this.recipientInfos;
    }

    public SET getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public SET getCertificates() {
        return this.certificates;
    }

    public SET getCrls() {
        return this.crls;
    }

    public SET getSignerInfos() {
        return this.signerInfos;
    }

    private SignedAndEnvelopedData() {
    }

    public SignedAndEnvelopedData(INTEGER version, SET recipientInfos, SET digestAlgorithms, EncryptedContentInfo encryptedContentInfo, SET certificates, SET crls, SET signerInfos) {
        if (version == null || recipientInfos == null || digestAlgorithms == null || encryptedContentInfo == null || signerInfos == null) {
            throw new IllegalArgumentException("SignedAndEnvelopedData constructor parameter is null");
        }
        this.version = version;
        this.recipientInfos = recipientInfos;
        this.digestAlgorithms = digestAlgorithms;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(version);
        this.sequence.addElement(recipientInfos);
        this.sequence.addElement(digestAlgorithms);
        this.sequence.addElement(encryptedContentInfo);
        if (certificates != null) {
            this.sequence.addElement(certificates);
        }
        if (crls != null) {
            this.sequence.addElement(crls);
        }
        this.sequence.addElement(signerInfos);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SET.OF_Template(RecipientInfo.getTemplate()));
            this.seqt.addElement(new SET.OF_Template(AlgorithmIdentifier.getTemplate()));
            this.seqt.addElement(EncryptedContentInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(ANY.getTemplate()));
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(new SET.OF_Template(SignerInfo.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new SignedAndEnvelopedData((INTEGER)seq.elementAt(0), (SET)seq.elementAt(1), (SET)seq.elementAt(2), (EncryptedContentInfo)seq.elementAt(3), (SET)seq.elementAt(4), (SET)seq.elementAt(5), (SET)seq.elementAt(6));
        }
    }
}

