/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.text.DateFormat;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.ChallengeResponseException;
import org.mozilla.jss.pkix.crmf.POPOPrivKey;
import org.mozilla.jss.pkix.crmf.POPOSigningKey;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

public class CertReqMsg
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private CertRequest certReq;
    private SEQUENCE regInfo;
    private ProofOfPossession pop = null;
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public CertRequest getCertReq() {
        return this.certReq;
    }

    public boolean hasRegInfo() {
        return this.regInfo != null;
    }

    public SEQUENCE getRegInfo() {
        Assert._assert(this.regInfo != null);
        return this.regInfo;
    }

    public boolean hasPop() {
        return this.pop != null;
    }

    public ProofOfPossession getPop() {
        Assert._assert(this.pop != null);
        return this.pop;
    }

    private CertReqMsg() {
    }

    public CertReqMsg(CertRequest certReq, ProofOfPossession pop, SEQUENCE regInfo) {
        this.certReq = certReq;
        this.pop = pop;
        this.regInfo = regInfo;
    }

    public void verify() throws SignatureException, InvalidKeyFormatException, NoSuchAlgorithmException, CryptoManager.NotInitializedException, TokenException, InvalidKeyException, IOException {
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        this.verify(token);
    }

    public void verify(CryptoToken token) throws SignatureException, InvalidKeyFormatException, NoSuchAlgorithmException, CryptoManager.NotInitializedException, TokenException, InvalidKeyException, IOException {
        POPOPrivKey keyEnc;
        POPOPrivKey.Type ptype;
        ProofOfPossession.Type type = this.pop.getType();
        if (type == ProofOfPossession.SIGNATURE) {
            POPOSigningKey sigkey = this.pop.getSignature();
            AlgorithmIdentifier alg2 = sigkey.getAlgorithmIdentifier();
            BIT_STRING sig_from = sigkey.getSignature();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            this.certReq.encode(bo);
            byte[] toBeVerified = bo.toByteArray();
            PublicKey pubkey = null;
            CertTemplate ct = this.certReq.getCertTemplate();
            if (ct.hasPublicKey()) {
                SubjectPublicKeyInfo spi = ct.getPublicKey();
                pubkey = spi.toPublicKey();
            }
            SignatureAlgorithm sigAlg = SignatureAlgorithm.fromOID(alg2.getOID());
            Signature sig = token.getSignatureContext(sigAlg);
            sig.initVerify(pubkey);
            sig.update(toBeVerified);
            if (sig.verify(sig_from.getBits())) {
                return;
            }
            throw new SignatureException("Signed request information does not match signature in POP");
        }
        if (type == ProofOfPossession.KEY_ENCIPHERMENT && (ptype = (keyEnc = this.pop.getKeyEncipherment()).getType()) != POPOPrivKey.THIS_MESSAGE && ptype == POPOPrivKey.SUBSEQUENT_MESSAGE) {
            new ChallengeResponseException("requested");
        }
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE sequence = new SEQUENCE();
        sequence.addElement(this.certReq);
        if (this.pop != null) {
            sequence.addElement(this.pop);
        }
        if (this.regInfo != null) {
            sequence.addElement(this.regInfo);
        }
        sequence.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.err.println("Give an arg");
                System.exit(0);
            }
            FileInputStream fis = new FileInputStream(args[0]);
            SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(new Template());
            SEQUENCE seq = null;
            byte[] bytes = new byte[fis.available()];
            fis.read(bytes);
            for (int i = 0; i < 1; ++i) {
                seq = (SEQUENCE)seqt.decode(new ByteArrayInputStream(bytes));
            }
            System.out.println("Decoded " + seq.size() + " messages");
            CertReqMsg reqmsg = (CertReqMsg)seq.elementAt(0);
            CertRequest certreq = reqmsg.getCertReq();
            System.out.println("Request ID: " + certreq.getCertReqId());
            CertTemplate temp = certreq.getCertTemplate();
            if (temp.hasVersion()) {
                System.out.println("Version: " + temp.getVersion());
            } else {
                System.out.println("No version");
            }
            if (temp.hasSerialNumber()) {
                System.out.println("Serial Number: " + temp.getSerialNumber());
            } else {
                System.out.println("No serial number");
            }
            if (temp.hasSigningAlg()) {
                System.out.println("SigningAlg: " + temp.getSigningAlg().getOID());
            } else {
                System.out.println("No signing alg");
            }
            if (temp.hasIssuer()) {
                System.out.println("Issuer: " + temp.getIssuer().getRFC1485());
            } else {
                System.out.println("No issuer");
            }
            if (temp.hasSubject()) {
                System.out.println("Subject: " + temp.getSubject().getRFC1485());
            } else {
                System.out.println("No subject: ");
            }
            if (temp.hasPublicKey()) {
                System.out.println("Public Key: " + temp.getPublicKey().getAlgorithmIdentifier().getOID());
            } else {
                System.out.println("No public key");
            }
            if (temp.hasIssuerUID()) {
                System.out.println("Issuer UID: " + new BigInteger(temp.getIssuerUID().getBits()));
            } else {
                System.out.println("no issuer uid");
            }
            if (temp.hasSubjectUID()) {
                System.out.println("Subject UID: " + new BigInteger(temp.getIssuerUID().getBits()));
            } else {
                System.out.println("no subject uid");
            }
            if (temp.hasNotBefore()) {
                System.out.println("Not Before: " + DateFormat.getInstance().format(temp.getNotBefore()));
            }
            if (temp.hasNotAfter()) {
                System.out.println("Not After: " + DateFormat.getInstance().format(temp.getNotAfter()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag t) {
            return TAG.equals(t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new CertRequest.Template());
            seqt.addOptionalElement(new ProofOfPossession.Template());
            seqt.addOptionalElement(new SEQUENCE.OF_Template(new AVA.Template()));
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            return new CertReqMsg((CertRequest)seq.elementAt(0), (ProofOfPossession)seq.elementAt(1), (SEQUENCE)seq.elementAt(2));
        }
    }
}

