/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.EncryptedValue;
import org.mozilla.jss.util.Assert;

public class EncryptedKey
implements ASN1Value {
    public static final Type ENCRYPTED_VALUE = Type.ENCRYPTED_VALUE;
    public static final Type ENVELOPED_DATA = Type.ENVELOPED_DATA;
    private Type type;
    private EncryptedValue encryptedValue;
    private ANY envelopedData;
    private Tag tag;
    private static final Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public EncryptedValue getEncryptedValue() {
        return this.encryptedValue;
    }

    public ANY getEnvelopedData() {
        return this.envelopedData;
    }

    private EncryptedKey() {
    }

    public EncryptedKey(EncryptedValue encryptedValue) {
        this.type = ENCRYPTED_VALUE;
        this.encryptedValue = encryptedValue;
        this.tag = SEQUENCE.TAG;
    }

    public EncryptedKey(ANY envelopedData) {
        this.type = ENVELOPED_DATA;
        this.envelopedData = envelopedData;
        this.tag = new Tag(0L);
    }

    public Tag getTag() {
        return this.tag;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        Assert._assert(this.getTag().equals(implicitTag));
        if (this.type == ENCRYPTED_VALUE) {
            Assert._assert(this.encryptedValue != null);
            this.encryptedValue.encode(implicitTag, ostream);
        } else {
            Assert._assert(this.type == ENVELOPED_DATA);
            Assert._assert(this.envelopedData != null);
            this.envelopedData.encode(implicitTag, ostream);
        }
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(EncryptedValue.getTemplate());
            this.choicet.addElement(new Tag(0L), ANY.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            try {
                CHOICE choice = (CHOICE)this.choicet.decode(istream);
                if (choice.getTag().equals(SEQUENCE.TAG)) {
                    return new EncryptedKey((EncryptedValue)choice.getValue());
                }
                Assert._assert(choice.getTag().equals(new Tag(0L)));
                return new EncryptedKey((ANY)choice.getValue());
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "EncryptedKey");
            }
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            Assert.notReached("EncryptedKey, being a CHOICE, cannot be implicitly tagged");
            return this.decode(istream);
        }
    }

    public static class Type {
        static final Type ENCRYPTED_VALUE = new Type();
        static final Type ENVELOPED_DATA = new Type();

        private Type() {
        }
    }
}

