/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class EncryptedValue
implements ASN1Value {
    private AlgorithmIdentifier intendedAlg;
    private AlgorithmIdentifier symmAlg;
    private BIT_STRING encSymmKey;
    private AlgorithmIdentifier keyAlg;
    private OCTET_STRING valueHint;
    private BIT_STRING encValue;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AlgorithmIdentifier getIntendedAlg() {
        return this.intendedAlg;
    }

    public AlgorithmIdentifier getSymmAlg() {
        return this.symmAlg;
    }

    public BIT_STRING getEncSymmKey() {
        return this.encSymmKey;
    }

    public AlgorithmIdentifier getKeyAlg() {
        return this.keyAlg;
    }

    public OCTET_STRING getValueHint() {
        return this.valueHint;
    }

    public BIT_STRING getEncValue() {
        return this.encValue;
    }

    private EncryptedValue() {
    }

    public EncryptedValue(AlgorithmIdentifier intendedAlg, AlgorithmIdentifier symmAlg, BIT_STRING encSymmKey, AlgorithmIdentifier keyAlg, OCTET_STRING valueHint, BIT_STRING encValue) {
        if (encValue == null) {
            throw new IllegalArgumentException("encValue is null");
        }
        this.intendedAlg = intendedAlg;
        this.symmAlg = symmAlg;
        this.encSymmKey = encSymmKey;
        this.keyAlg = keyAlg;
        this.valueHint = valueHint;
        this.encValue = encValue;
        this.sequence = new SEQUENCE();
        if (intendedAlg != null) {
            this.sequence.addElement(new Tag(0L), intendedAlg);
        }
        if (symmAlg != null) {
            this.sequence.addElement(new Tag(1L), symmAlg);
        }
        if (encSymmKey != null) {
            this.sequence.addElement(new Tag(2L), encSymmKey);
        }
        if (keyAlg != null) {
            this.sequence.addElement(new Tag(3L), keyAlg);
        }
        if (valueHint != null) {
            this.sequence.addElement(new Tag(4L), valueHint);
        }
        this.sequence.addElement(encValue);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement(new Tag(0L), AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(2L), BIT_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(3L), AlgorithmIdentifier.getTemplate());
            this.seqt.addOptionalElement(new Tag(4L), OCTET_STRING.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            try {
                SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
                return new EncryptedValue((AlgorithmIdentifier)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (BIT_STRING)seq.elementAt(2), (AlgorithmIdentifier)seq.elementAt(3), (OCTET_STRING)seq.elementAt(4), (BIT_STRING)seq.elementAt(5));
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "EncryptedValue");
            }
        }
    }
}

