/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.crmf.EncryptedKey;
import org.mozilla.jss.util.Assert;

public class PKIArchiveOptions
implements ASN1Value {
    public static final Type ENCRYPTED_PRIV_KEY = Type.ENCRYPTED_PRIV_KEY;
    public static final Type KEY_GEN_PARAMETERS = Type.KEY_GEN_PARAMETERS;
    public static final Type ARCHIVE_REM_GEN_PRIV_KEY = Type.ARCHIVE_REM_GEN_PRIV_KEY;
    private EncryptedKey encryptedPrivKey;
    private OCTET_STRING keyGenParameters;
    private boolean archiveRemGenPrivKey;
    private Type type;
    private Tag tag;
    private static final Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public EncryptedKey getEncryptedKey() {
        Assert._assert(this.type == ENCRYPTED_PRIV_KEY);
        return this.encryptedPrivKey;
    }

    public boolean getArchiveRemGenPrivKey() {
        Assert._assert(this.type == ARCHIVE_REM_GEN_PRIV_KEY);
        return this.archiveRemGenPrivKey;
    }

    private PKIArchiveOptions() {
    }

    public PKIArchiveOptions(EncryptedKey eKey) {
        this.encryptedPrivKey = eKey;
        this.type = ENCRYPTED_PRIV_KEY;
        this.tag = new Tag(0L);
    }

    public PKIArchiveOptions(byte[] keyGenParameters) {
        this.keyGenParameters = new OCTET_STRING(keyGenParameters);
        this.type = KEY_GEN_PARAMETERS;
        this.tag = new Tag(1L);
    }

    public PKIArchiveOptions(boolean archiveRemGenPrivKey) {
        this.archiveRemGenPrivKey = archiveRemGenPrivKey;
        this.type = ARCHIVE_REM_GEN_PRIV_KEY;
        this.tag = new Tag(2L);
    }

    public Tag getTag() {
        return this.tag;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        Assert._assert(implicitTag.equals(this.tag));
        if (this.type == ENCRYPTED_PRIV_KEY) {
            EXPLICIT explicit = new EXPLICIT(new Tag(0L), this.encryptedPrivKey);
            explicit.encode(this.tag, ostream);
        } else if (this.type == KEY_GEN_PARAMETERS) {
            this.keyGenParameters.encode(this.tag, ostream);
        } else {
            Assert._assert(this.type == ARCHIVE_REM_GEN_PRIV_KEY);
            new BOOLEAN(this.archiveRemGenPrivKey).encode(this.tag, ostream);
        }
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        CHOICE.Template template = new CHOICE.Template();

        public Template() {
            this.template.addElement(new EXPLICIT.Template(new Tag(0L), new EncryptedKey.Template()));
            this.template.addElement(new Tag(1L), new OCTET_STRING.Template());
            this.template.addElement(new Tag(2L), new BOOLEAN.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.template.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.template.decode(istream);
            if (choice.getTag().getNum() == 0L) {
                EncryptedKey ekey = (EncryptedKey)((EXPLICIT)choice.getValue()).getContent();
                return new PKIArchiveOptions(ekey);
            }
            if (choice.getTag().getNum() == 1L) {
                OCTET_STRING kgp = (OCTET_STRING)choice.getValue();
                return new PKIArchiveOptions(kgp.toByteArray());
            }
            if (choice.getTag().getNum() == 2L) {
                BOOLEAN arckey = (BOOLEAN)choice.getValue();
                return new PKIArchiveOptions(arckey.toBoolean());
            }
            String s = "Unrecognized tag in PKIArchiveOptions";
            Assert.notReached(s);
            throw new InvalidBERException(s);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }
    }

    public static class Type {
        static final Type ENCRYPTED_PRIV_KEY = new Type();
        static final Type KEY_GEN_PARAMETERS = new Type();
        static final Type ARCHIVE_REM_GEN_PRIV_KEY = new Type();

        private Type() {
        }
    }
}

