/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class POPOPrivKey
implements ASN1Value {
    public static final Type THIS_MESSAGE = Type.THIS_MESSAGE;
    public static final Type SUBSEQUENT_MESSAGE = Type.SUBSEQUENT_MESSAGE;
    public static final Type DHMAC = Type.DHMAC;
    public static final int ENCR_CERT = 0;
    public static final int CHALLENGE_RESP = 1;
    private Type type;
    private BIT_STRING thisMessage;
    private INTEGER subsequentMessage;
    private BIT_STRING dhMAC;
    private static final Template templateInstance = new Template();

    public Type getType() {
        return this.type;
    }

    public BIT_STRING getThisMessage() {
        return this.thisMessage;
    }

    public INTEGER getSubsequentMessage() {
        return this.subsequentMessage;
    }

    public BIT_STRING getDhMAC() {
        return this.dhMAC;
    }

    private POPOPrivKey() {
    }

    private POPOPrivKey(Type type, BIT_STRING thisMessage, INTEGER subsequentMessage, BIT_STRING dhMAC) {
        this.type = type;
        this.thisMessage = thisMessage;
        this.subsequentMessage = subsequentMessage;
        this.dhMAC = dhMAC;
    }

    public static POPOPrivKey createThisMessage(BIT_STRING thisMessage) {
        return new POPOPrivKey(THIS_MESSAGE, thisMessage, null, null);
    }

    public static POPOPrivKey createSubsequentMessage(int subsequentMessage) {
        if (subsequentMessage != 0 && subsequentMessage != 1) {
            throw new IllegalArgumentException("Illegal subsequentMessage value: " + subsequentMessage);
        }
        return new POPOPrivKey(SUBSEQUENT_MESSAGE, null, new INTEGER(subsequentMessage), null);
    }

    public static POPOPrivKey createDhMAC(BIT_STRING dhMAC) {
        return new POPOPrivKey(DHMAC, null, null, dhMAC);
    }

    public Tag getTag() {
        if (this.type == THIS_MESSAGE) {
            return Tag.get(0L);
        }
        if (this.type == SUBSEQUENT_MESSAGE) {
            return Tag.get(1L);
        }
        Assert._assert(this.type == DHMAC);
        return Tag.get(2L);
    }

    public void encode(OutputStream ostream) throws IOException {
        if (this.type == THIS_MESSAGE) {
            this.thisMessage.encode(Tag.get(0L), ostream);
        } else if (this.type == SUBSEQUENT_MESSAGE) {
            this.subsequentMessage.encode(Tag.get(1L), ostream);
        } else {
            Assert._assert(this.type == DHMAC);
            this.dhMAC.encode(Tag.get(2L), ostream);
        }
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        Assert.notReached("POPOPrivKey is a CHOICE and cannot have an implicit tag");
        this.encode(ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), BIT_STRING.getTemplate());
            this.choicet.addElement(Tag.get(1L), INTEGER.getTemplate());
            this.choicet.addElement(Tag.get(2L), BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            Assert.notReached("POPOPrivKey is a CHOICE and cannot have an implicitTag");
            return this.decode(istream);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            CHOICE choice = (CHOICE)this.choicet.decode(istream);
            Tag chosen = choice.getTag();
            if (chosen.equals(Tag.get(0L))) {
                return POPOPrivKey.createThisMessage((BIT_STRING)choice.getValue());
            }
            if (chosen.equals(Tag.get(1L))) {
                INTEGER I = (INTEGER)choice.getValue();
                int i = I.intValue();
                if (i != 0 && i != 1) {
                    throw new InvalidBERException("SubsequentMessage has invalid value: " + i);
                }
                return POPOPrivKey.createSubsequentMessage(i);
            }
            Assert._assert(chosen.equals(Tag.get(2L)));
            return POPOPrivKey.createDhMAC((BIT_STRING)choice.getValue());
        }
    }

    public static class Type {
        static final Type THIS_MESSAGE = new Type();
        static final Type SUBSEQUENT_MESSAGE = new Type();
        static final Type DHMAC = new Type();

        private Type() {
        }
    }
}

