/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class POPOSigningKey
implements ASN1Value {
    private ANY poposkInput;
    private AlgorithmIdentifier algorithmIdentifier;
    private BIT_STRING signature;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ANY getPoposkInput() {
        return this.poposkInput;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public BIT_STRING getSignature() {
        return this.signature;
    }

    private POPOSigningKey() {
    }

    public POPOSigningKey(ANY poposkInput, AlgorithmIdentifier algorithmIdentifier, BIT_STRING signature) {
        if (algorithmIdentifier == null || signature == null) {
            throw new IllegalArgumentException("parameter to POPOSigningKey constructor is null");
        }
        this.poposkInput = poposkInput;
        this.algorithmIdentifier = algorithmIdentifier;
        this.signature = signature;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(Tag.get(0L), poposkInput);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(signature);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement(new EXPLICIT.Template(Tag.get(0L), ANY.getTemplate()));
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new POPOSigningKey((ANY)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1), (BIT_STRING)seq.elementAt(2));
        }
    }
}

