/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class Attribute
implements ASN1Value {
    private OBJECT_IDENTIFIER type;
    private SET values;
    public static final Tag TAG = SEQUENCE.TAG;
    private static Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    private Attribute() {
    }

    public Attribute(OBJECT_IDENTIFIER type, SET values) {
        this.type = type;
        this.values = values;
    }

    public Attribute(OBJECT_IDENTIFIER type, ASN1Value value) {
        this.type = type;
        this.values = new SET();
        this.values.addElement(value);
    }

    public OBJECT_IDENTIFIER getType() {
        return this.type;
    }

    public SET getValues() {
        return this.values;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.type);
        seq.addElement(this.values);
        seq.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new OBJECT_IDENTIFIER.Template());
            seqt.addElement(new SET.OF_Template(new ANY.Template()));
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            Assert._assert(seq.size() == 2);
            return new Attribute((OBJECT_IDENTIFIER)seq.elementAt(0), (SET)seq.elementAt(1));
        }
    }
}

