/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PBEParameter;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class EncryptedPrivateKeyInfo
implements ASN1Value {
    private AlgorithmIdentifier encryptionAlgorithm;
    private OCTET_STRING encryptedData;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();
    static /* synthetic */ Class class$org$mozilla$jss$crypto$IVParameterSpec;

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public OCTET_STRING getEncryptedData() {
        return this.encryptedData;
    }

    private EncryptedPrivateKeyInfo() {
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier encryptionAlgorithm, OCTET_STRING encryptedData) {
        if (encryptionAlgorithm == null || encryptedData == null) {
            throw new IllegalArgumentException("EncryptedPrivateKeyInfo parameter is null");
        }
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptedData = encryptedData;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(encryptionAlgorithm);
        this.sequence.addElement(encryptedData);
    }

    public static EncryptedPrivateKeyInfo createPBE(PBEAlgorithm keyGenAlg, Password password, byte[] salt, int iterationCount, KeyGenerator.CharToByteConverter charToByteConverter, PrivateKeyInfo pki) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, CharConversionException {
        try {
            if (!(keyGenAlg instanceof PBEAlgorithm)) {
                throw new NoSuchAlgorithmException("Key generation algorithm is not a PBE algorithm");
            }
            PBEAlgorithm pbeAlg = keyGenAlg;
            CryptoManager cman = CryptoManager.getInstance();
            CryptoToken token = cman.getInternalCryptoToken();
            KeyGenerator kg = token.getKeyGenerator(keyGenAlg);
            PBEKeyGenParams pbekgParams = new PBEKeyGenParams(password, salt, iterationCount);
            if (charToByteConverter != null) {
                kg.setCharToByteConverter(charToByteConverter);
            }
            kg.initialize(pbekgParams);
            SymmetricKey key = kg.generate();
            EncryptionAlgorithm encAlg = pbeAlg.getEncryptionAlg();
            IVParameterSpec params = null;
            if (encAlg.getParameterClass().equals(class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptedPrivateKeyInfo.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec)) {
                params = new IVParameterSpec(kg.generatePBE_IV());
            }
            Cipher cipher2 = token.getCipherContext(encAlg);
            cipher2.initEncrypt(key, params);
            byte[] encrypted = cipher2.doFinal(Cipher.pad(ASN1Util.encode(pki), encAlg.getBlockSize()));
            PBEParameter pbeParam = new PBEParameter(salt, iterationCount);
            AlgorithmIdentifier encAlgID = new AlgorithmIdentifier(keyGenAlg.toOID(), pbeParam);
            EncryptedPrivateKeyInfo epki = new EncryptedPrivateKeyInfo(encAlgID, new OCTET_STRING(encrypted));
            return epki;
        }
        catch (IllegalBlockSizeException e) {
            Assert.notReached("IllegalBlockSizeException in EncryptedContentInfo.createPBE");
        }
        catch (BadPaddingException e) {
            Assert.notReached("BadPaddingException in EncryptedContentInfo.createPBE");
        }
        return null;
    }

    public PrivateKeyInfo decrypt(Password pass, KeyGenerator.CharToByteConverter charToByteConverter) throws CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidBERException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException, CharConversionException {
        PBEParameter pbeParams;
        AlgorithmIdentifier algid = this.encryptionAlgorithm;
        KeyGenAlgorithm kgAlg = KeyGenAlgorithm.fromOID(algid.getOID());
        if (!(kgAlg instanceof PBEAlgorithm)) {
            throw new NoSuchAlgorithmException("KeyGenAlgorithm is not a PBE algorithm");
        }
        ASN1Value params = algid.getParameters();
        if (params == null) {
            throw new InvalidAlgorithmParameterException("PBE algorithms require parameters");
        }
        if (params instanceof PBEParameter) {
            pbeParams = (PBEParameter)params;
        } else {
            byte[] encodedParams = ASN1Util.encode(params);
            pbeParams = (PBEParameter)ASN1Util.decode(PBEParameter.getTemplate(), encodedParams);
        }
        PBEKeyGenParams kgp = new PBEKeyGenParams(pass, pbeParams.getSalt(), pbeParams.getIterations());
        CryptoToken token = CryptoManager.getInstance().getInternalCryptoToken();
        KeyGenerator kg = token.getKeyGenerator(kgAlg);
        if (charToByteConverter != null) {
            kg.setCharToByteConverter(charToByteConverter);
        }
        kg.initialize(kgp);
        SymmetricKey key = kg.generate();
        EncryptionAlgorithm encAlg = ((PBEAlgorithm)kgAlg).getEncryptionAlg();
        IVParameterSpec algParams = encAlg.getParameterClass().equals(class$org$mozilla$jss$crypto$IVParameterSpec == null ? (class$org$mozilla$jss$crypto$IVParameterSpec = EncryptedPrivateKeyInfo.class$("org.mozilla.jss.crypto.IVParameterSpec")) : class$org$mozilla$jss$crypto$IVParameterSpec) ? new IVParameterSpec(kg.generatePBE_IV()) : null;
        Cipher cipher2 = token.getCipherContext(encAlg);
        cipher2.initDecrypt(key, algParams);
        byte[] decrypted = Cipher.unPad(cipher2.doFinal(this.encryptedData.toByteArray()));
        return (PrivateKeyInfo)ASN1Util.decode(PrivateKeyInfo.getTemplate(), decrypted);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new EncryptedPrivateKeyInfo((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

