/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.pkcs11.TokenProxy;

public class JSSKeyStoreSpi
extends KeyStoreSpi {
    protected TokenProxy proxy;
    private CertificateFactory certFactory = null;

    public JSSKeyStoreSpi() {
        try {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        CryptoToken token = TokenSupplierManager.getTokenSupplier().getThreadToken();
        PK11Token pk11tok = (PK11Token)token;
        this.proxy = pk11tok.getProxy();
    }

    private native HashSet getRawAliases();

    public Enumeration engineAliases() {
        return new IteratorEnumeration(this.getRawAliases().iterator());
    }

    public boolean engineContainsAlias(String alias) {
        return this.getRawAliases().contains(alias);
    }

    public native void engineDeleteEntry(String var1);

    public Certificate engineGetCertificate(String alias) {
        byte[] derCert = this.getDERCert(alias);
        if (derCert == null) {
            return null;
        }
        try {
            return this.certFactory.generateCertificate(new ByteArrayInputStream(derCert));
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private native byte[] getDERCert(String var1);

    private native X509Certificate getCertObject(String var1);

    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.getCertNickname(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return null;
        }
    }

    private native String getCertNickname(byte[] var1);

    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            X509Certificate leaf = this.getCertObject(alias);
            if (leaf == null) {
                return null;
            }
            CryptoManager cm = CryptoManager.getInstance();
            X509Certificate[] jssChain = cm.buildCertificateChain(leaf);
            Certificate[] chain = new Certificate[jssChain.length];
            for (int i = 0; i < chain.length; ++i) {
                chain[i] = this.certFactory.generateCertificate(new ByteArrayInputStream(jssChain[i].getEncoded()));
            }
            return chain;
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.toString());
        }
        catch (CryptoManager.NotInitializedException e) {
            throw new RuntimeException("CryptoManager not initialized");
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    public Date engineGetCreationDate(String alias) {
        return null;
    }

    public Key engineGetKey(String alias, char[] password) {
        Object o = this.engineGetKeyNative(alias, password);
        if (o instanceof SymmetricKey) {
            return new SecretKeyFacade((SymmetricKey)o);
        }
        return (Key)o;
    }

    public native Object engineGetKeyNative(String var1, char[] var2);

    public native boolean engineIsCertificateEntry(String var1);

    public boolean engineIsKeyEntry(String alias) {
        return this.engineGetKey(alias, null) != null;
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException {
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw new KeyStoreException("Storing trusted certificate entries to a JSS KeyStore is not supported.");
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Storing plaintext keys is not supported.Store the key as a handle instead.");
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (key instanceof SecretKeyFacade) {
            SecretKeyFacade skf = (SecretKeyFacade)key;
            this.engineSetKeyEntryNative(alias, skf.key, password, chain);
        } else {
            this.engineSetKeyEntryNative(alias, key, password, chain);
        }
    }

    private native void engineSetKeyEntryNative(String var1, Object var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public int engineSize() {
        return this.getRawAliases().size();
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException {
    }

    private static class IteratorEnumeration
    implements Enumeration {
        private Iterator iter;

        public IteratorEnumeration(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

