/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

public abstract class JSSMessageDigestSpi
extends MessageDigestSpi {
    private JSSMessageDigest digest;

    private JSSMessageDigestSpi() {
    }

    protected JSSMessageDigestSpi(DigestAlgorithm alg2) {
        CryptoToken token = TokenSupplierManager.getTokenSupplier().getThreadToken();
        try {
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken ikst = cm.getInternalKeyStorageToken();
            if (((Object)token).equals(ikst)) {
                token = cm.getInternalCryptoToken();
            }
            try {
                this.digest = token.getDigestContext(alg2);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException("Token '" + token.getName() + "' does not support " + "algorithm " + alg2.toString());
            }
        }
        catch (TokenException e) {
            throw new TokenRuntimeException(e.getMessage());
        }
        catch (DigestException e1) {
            throw new TokenRuntimeException(e1.getMessage());
        }
        catch (CryptoManager.NotInitializedException e2) {
            throw new TokenRuntimeException(e2.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public byte[] engineDigest() {
        try {
            return this.digest.digest();
        }
        catch (DigestException de) {
            throw new TokenRuntimeException(de.getMessage());
        }
    }

    public int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        return this.digest.digest(buf, offset, len);
    }

    public int engineGetDigestLength() {
        return this.digest.getOutputSize();
    }

    public void engineReset() {
        try {
            this.digest.reset();
        }
        catch (DigestException de) {
            throw new TokenRuntimeException(de.getMessage());
        }
    }

    public void engineUpdate(byte input) {
        try {
            this.digest.update(input);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException(de.getMessage());
        }
    }

    public void engineUpdate(byte[] input, int offset, int len) {
        try {
            this.digest.update(input, offset, len);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException(de.getMessage());
        }
    }

    public static class MD2
    extends JSSMessageDigestSpi {
        public MD2() {
            super(DigestAlgorithm.MD2);
        }
    }

    public static class MD5
    extends JSSMessageDigestSpi {
        public MD5() {
            super(DigestAlgorithm.MD5);
        }
    }

    public static class SHA512
    extends JSSMessageDigestSpi {
        public SHA512() {
            super(DigestAlgorithm.SHA512);
        }
    }

    public static class SHA384
    extends JSSMessageDigestSpi {
        public SHA384() {
            super(DigestAlgorithm.SHA384);
        }
    }

    public static class SHA256
    extends JSSMessageDigestSpi {
        public SHA256() {
            super(DigestAlgorithm.SHA256);
        }
    }

    public static class SHA1
    extends JSSMessageDigestSpi {
        public SHA1() {
            super(DigestAlgorithm.SHA1);
        }
    }
}

