/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.util.Assert;

public class RC2AlgorithmParameters
extends AlgorithmParametersSpi {
    private RC2ParameterSpec RC2ParamSpec;

    public void engineInit(AlgorithmParameterSpec paramSpec) {
        this.RC2ParamSpec = (RC2ParameterSpec)paramSpec;
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz != null && !clazz.isInstance(this.RC2ParamSpec)) {
            Class<?> paramSpecClass = this.RC2ParamSpec.getClass();
            throw new InvalidParameterSpecException("RC2 getParameterSpec has class " + paramSpecClass.getName());
        }
        return this.RC2ParamSpec;
    }

    public void engineInit(byte[] params) throws IOException {
        Assert.notReached("engineInit(byte[]) not supported");
        throw new IOException("engineInit(byte[]) not supported");
    }

    public void engineInit(byte[] params, String format) throws IOException {
        Assert.notReached("engineInit(byte[],String) not supported");
        throw new IOException("engineInit(byte[],String) not supported");
    }

    public byte[] engineGetEncoded() throws IOException {
        Assert.notReached("encoding RC2AlgorithmParameters not supported");
        throw new IOException("encoding RC2AlgorithmParameters not supported");
    }

    public byte[] engineGetEncoded(String format) throws IOException {
        Assert.notReached("encoding RC2AlgorithmParameters not supported");
        throw new IOException("encoding RC2AlgorithmParameters not supported");
    }

    public String engineToString() {
        String str = new String("Mozilla-JSS RC2AlgorithmParameters " + this.getClass().getName());
        return str;
    }
}

