/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Algorithm;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

class JSSCipherSpi
extends CipherSpi {
    private String algFamily = null;
    private String algMode = null;
    private String algPadding = null;
    CryptoToken token = null;
    private Cipher cipher = null;
    private EncryptionAlgorithm encAlg = null;
    private KeyWrapper wrapper = null;
    private KeyWrapAlgorithm wrapAlg = null;
    private AlgorithmParameterSpec params = null;
    private int blockSize;
    private int keyStrength;
    private static final NoAlgParams noAlgParams = new NoAlgParams();
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    private JSSCipherSpi() {
    }

    protected JSSCipherSpi(String algFamily) {
        this.algFamily = algFamily;
        this.token = TokenSupplierManager.getTokenSupplier().getThreadToken();
    }

    public void engineSetMode(String mode) {
        this.algMode = mode;
    }

    public void engineSetPadding(String padding) {
        this.algPadding = padding;
    }

    private static SecretKey importKey(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            SecretKey sKey = (SecretKey)key;
            SecretKeyFactory fact = null;
            try {
                fact = SecretKeyFactory.getInstance(sKey.getAlgorithm(), "Mozilla-JSS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Unable to translate key with Algorithm" + key.getAlgorithm());
            }
            catch (NoSuchProviderException ex) {
                throw new InvalidKeyException("Unable to find provider, this should not happen");
            }
            return fact.translateKey(sKey);
        }
        throw new InvalidKeyException("Invalid key type: " + key.getClass().getName());
    }

    public void engineInit(int opmode, Key key, AlgorithmParameterSpec givenParams, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block25: {
            try {
                this.cipher = null;
                this.wrapper = null;
                this.params = givenParams;
                if (this.algFamily == null) {
                    throw new InvalidAlgorithmParameterException("incorrectly specified algorithm");
                }
                if (opmode != 1 && opmode != 2 && opmode != 3 && opmode != 4) {
                    throw new InvalidKeyException("Invalid opmode");
                }
                StringBuffer buf = new StringBuffer();
                buf.append(this.algFamily);
                if (this.algMode != null) {
                    buf.append('/');
                    buf.append(this.algMode);
                }
                if (this.algPadding != null) {
                    buf.append('/');
                    buf.append(this.algPadding);
                }
                if (opmode == 1 || opmode == 2) {
                    if (!(key instanceof SecretKeyFacade)) {
                        key = JSSCipherSpi.importKey(key);
                    }
                    SymmetricKey symkey = ((SecretKeyFacade)key).key;
                    this.keyStrength = symkey.getStrength();
                    this.encAlg = EncryptionAlgorithm.lookup(this.algFamily, this.algMode, this.algPadding, this.keyStrength);
                    this.blockSize = this.encAlg.getBlockSize();
                    if (!this.token.doesAlgorithm(this.encAlg)) {
                        throw new NoSuchAlgorithmException(this.encAlg.toString() + " is not supported by this token " + this.token.getName());
                    }
                    this.cipher = this.token.getCipherContext(this.encAlg);
                    if (opmode == 1) {
                        if (this.params == noAlgParams) {
                            this.params = this.generateAlgParams(this.encAlg, this.blockSize);
                        }
                        this.cipher.initEncrypt(symkey, this.params);
                    } else if (opmode == 2) {
                        if (this.params == noAlgParams) {
                            this.params = null;
                        }
                        this.cipher.initDecrypt(symkey, this.params);
                    }
                    break block25;
                }
                Assert._assert(opmode == 3 || opmode == 4);
                this.wrapAlg = KeyWrapAlgorithm.fromString(buf.toString());
                this.blockSize = this.wrapAlg.getBlockSize();
                this.wrapper = this.token.getKeyWrapper(this.wrapAlg);
                if (this.params == noAlgParams) {
                    if (opmode == 3) {
                        this.params = this.generateAlgParams(this.wrapAlg, this.blockSize);
                    } else {
                        Assert._assert(opmode == 4);
                        this.params = null;
                    }
                }
                if (key instanceof PrivateKey) {
                    if (opmode != 4) {
                        throw new InvalidKeyException("Private key can only be used for unwrapping");
                    }
                    this.wrapper.initUnwrap((PrivateKey)key, this.params);
                    break block25;
                }
                if (key instanceof PublicKey) {
                    if (opmode != 3) {
                        throw new InvalidKeyException("Public key can only be used for wrapping");
                    }
                    this.wrapper.initWrap((PublicKey)key, this.params);
                    break block25;
                }
                if (key instanceof SecretKeyFacade) {
                    SecretKeyFacade sk = (SecretKeyFacade)key;
                    if (opmode == 3) {
                        this.wrapper.initWrap(sk.key, this.params);
                    } else {
                        Assert._assert(opmode == 4);
                        this.wrapper.initUnwrap(sk.key, this.params);
                    }
                    break block25;
                }
                throw new InvalidKeyException("Invalid key type: " + key.getClass().getName());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidAlgorithmParameterException(e.getMessage());
            }
            catch (TokenException te) {
                throw new TokenRuntimeException(te.getMessage());
            }
        }
    }

    public void engineInit(int opmode, Key key, AlgorithmParameters givenParams, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            AlgorithmParameterSpec gp = null;
            if (this.algFamily.compareToIgnoreCase("RC2") == 0) {
                gp = (AlgorithmParameterSpec)givenParams.getParameterSpec(class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = JSSCipherSpi.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec);
            } else if (this.algMode.compareToIgnoreCase("CBC") == 0) {
                gp = (AlgorithmParameterSpec)givenParams.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JSSCipherSpi.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec);
            }
            if (gp == null) {
                throw new InvalidAlgorithmParameterException("Unknown Parameter Spec");
            }
            this.engineInit(opmode, key, gp, random);
        }
        catch (Exception e) {
            throw new InvalidAlgorithmParameterException(e.getMessage());
        }
    }

    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, noAlgParams, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    private AlgorithmParameterSpec generateAlgParams(Algorithm alg2, int blockSize) throws InvalidKeyException {
        Class[] paramClasses = alg2.getParameterClasses();
        AlgorithmParameterSpec algParSpec = null;
        if (paramClasses == null) {
            return null;
        }
        byte[] iv = new byte[blockSize];
        try {
            SecureRandom random = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            random.nextBytes(iv);
        }
        catch (Exception e) {
            Assert.notReached(e.getMessage());
        }
        for (int i = 0; i < paramClasses.length; ++i) {
            if (paramClasses[i].equals(class$javax$crypto$spec$IvParameterSpec == null ? JSSCipherSpi.class$("javax.crypto.spec.IvParameterSpec") : class$javax$crypto$spec$IvParameterSpec)) {
                algParSpec = new IvParameterSpec(iv);
                break;
            }
            if (!paramClasses[i].equals(class$javax$crypto$spec$RC2ParameterSpec == null ? JSSCipherSpi.class$("javax.crypto.spec.RC2ParameterSpec") : class$javax$crypto$spec$RC2ParameterSpec)) continue;
            algParSpec = new RC2ParameterSpec(this.keyStrength, iv);
            break;
        }
        return algParSpec;
    }

    public int engineGetBlockSize() {
        return this.blockSize;
    }

    public byte[] engineGetIV() {
        if (this.params == null) {
            return null;
        }
        if (this.params instanceof IvParameterSpec) {
            return ((IvParameterSpec)this.params).getIV();
        }
        if (this.params instanceof RC2ParameterSpec) {
            return ((RC2ParameterSpec)this.params).getIV();
        }
        return null;
    }

    public AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algParams = null;
        try {
            if (this.params instanceof IvParameterSpec || this.params instanceof RC2ParameterSpec) {
                algParams = AlgorithmParameters.getInstance(this.algFamily);
                algParams.init(this.params);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            Assert.notReached(nsae.getMessage());
        }
        catch (InvalidParameterSpecException ipse) {
            Assert.notReached(ipse.getMessage());
        }
        return algParams;
    }

    public int engineGetOutputSize(int inputLen) {
        int total = this.blockSize - 1 + inputLen;
        return (total / this.blockSize + 1) * this.blockSize;
    }

    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.cipher == null) {
            Assert.notReached();
            return null;
        }
        try {
            return this.cipher.update(input, inputOffset, inputLen);
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
    }

    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        byte[] bytes = this.engineUpdate(input, inputOffset, inputLen);
        if (bytes.length > output.length - outputOffset) {
            throw new ShortBufferException(bytes.length + " needed, " + (output.length - outputOffset) + " supplied");
        }
        System.arraycopy(bytes, 0, output, outputOffset, bytes.length);
        return bytes.length;
    }

    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws javax.crypto.IllegalBlockSizeException, BadPaddingException {
        if (this.cipher == null) {
            Assert.notReached();
            return null;
        }
        try {
            if (input == null || inputLen == 0) {
                return this.cipher.doFinal();
            }
            return this.cipher.doFinal(input, inputOffset, inputLen);
        }
        catch (IllegalStateException ise) {
            Assert.notReached();
            return null;
        }
        catch (IllegalBlockSizeException ibse) {
            throw new javax.crypto.IllegalBlockSizeException(ibse.getMessage());
        }
        catch (org.mozilla.jss.crypto.BadPaddingException bpe) {
            throw new BadPaddingException(bpe.getMessage());
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
    }

    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, javax.crypto.IllegalBlockSizeException, BadPaddingException {
        byte[] bytes = this.engineDoFinal(input, inputOffset, inputLen);
        if (bytes.length > output.length - outputOffset) {
            throw new ShortBufferException(bytes.length + " needed, " + (output.length - outputOffset) + " supplied");
        }
        System.arraycopy(bytes, 0, output, outputOffset, bytes.length);
        return bytes.length;
    }

    public byte[] engineWrap(Key key) throws javax.crypto.IllegalBlockSizeException, InvalidKeyException {
        if (this.wrapper == null) {
            Assert.notReached();
            return null;
        }
        try {
            if (key instanceof PrivateKey) {
                return this.wrapper.wrap((PrivateKey)key);
            }
            if (key instanceof SecretKeyFacade) {
                return this.wrapper.wrap(((SecretKeyFacade)key).key);
            }
            throw new InvalidKeyException("Unsupported key type: " + key.getClass().getName());
        }
        catch (IllegalStateException ise) {
            Assert.notReached();
            return null;
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
    }

    public Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.wrapper == null) {
            Assert.notReached();
            return null;
        }
        try {
            switch (wrappedKeyType) {
                case 3: {
                    return this.engineUnwrapSecret(wrappedKey, wrappedKeyAlgorithm);
                }
                case 2: {
                    return this.engineUnwrapPrivate(wrappedKey, wrappedKeyAlgorithm);
                }
                case 1: {
                    throw new UnsupportedOperationException("Unable to unwrap public keys");
                }
            }
            throw new NoSuchAlgorithmException("Invalid key type: " + wrappedKeyType);
        }
        catch (IllegalStateException ise) {
            Assert.notReached();
            return null;
        }
    }

    private Key engineUnwrapSecret(byte[] wrappedKey, String wrappedKeyAlg) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            int idx = wrappedKeyAlg.indexOf(47);
            if (idx != -1) {
                wrappedKeyAlg = wrappedKeyAlg.substring(0, idx);
            }
            SymmetricKey.Type wrappedKeyType = SymmetricKey.Type.fromName(wrappedKeyAlg);
            SymmetricKey key = this.wrapper.unwrapSymmetric(wrappedKey, wrappedKeyType, 0);
            return new SecretKeyFacade(key);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + wrappedKeyAlg);
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new NoSuchAlgorithmException("Invalid algorithm parameters" + iape.getMessage());
        }
    }

    private Key engineUnwrapPrivate(byte[] wrappedKey, String wrappedKeyAlg) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unwrapping private keys via the JCA interface is not supported: http://bugzilla.mozilla.org/show_bug.cgi?id=135328");
    }

    public int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PK11PrivKey) {
            return ((PK11PrivKey)key).getStrength();
        }
        if (key instanceof PK11PubKey) {
            try {
                byte[] encoded = ((PK11PubKey)key).getEncoded();
                SubjectPublicKeyInfo.Template spkiTemp = new SubjectPublicKeyInfo.Template();
                SubjectPublicKeyInfo spki = (SubjectPublicKeyInfo)ASN1Util.decode(spkiTemp, encoded);
                BIT_STRING pk = spki.getSubjectPublicKey();
                return pk.getBits().length - pk.getPadCount();
            }
            catch (InvalidBERException e) {
                throw new InvalidKeyException("Exception while decoding public key: " + e.getMessage());
            }
        }
        if (key instanceof SecretKeyFacade) {
            SymmetricKey symkey = ((SecretKeyFacade)key).key;
            return symkey.getLength();
        }
        key = JSSCipherSpi.importKey(key);
        SymmetricKey symkey = ((SecretKeyFacade)key).key;
        return symkey.getLength();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class RC2
    extends JSSCipherSpi {
        public RC2() {
            super("RC2");
        }
    }

    public static class RSA
    extends JSSCipherSpi {
        public RSA() {
            super("RSA");
        }
    }

    public static class RC4
    extends JSSCipherSpi {
        public RC4() {
            super("RC4");
        }
    }

    public static class AES
    extends JSSCipherSpi {
        public AES() {
            super("AES");
        }
    }

    public static class DESede
    extends JSSCipherSpi {
        public DESede() {
            super("DESede");
        }
    }

    public static class DES
    extends JSSCipherSpi {
        public DES() {
            super("DES");
        }
    }

    private static class NoAlgParams
    implements AlgorithmParameterSpec {
        private NoAlgParams() {
        }
    }
}

