/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.HMACAlgorithm;
import org.mozilla.jss.crypto.JSSMessageDigest;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

class JSSMacSpi
extends MacSpi {
    private JSSMessageDigest digest = null;
    private HMACAlgorithm alg;

    private JSSMacSpi() {
    }

    protected JSSMacSpi(HMACAlgorithm alg2) {
        try {
            this.alg = alg2;
            CryptoToken token = TokenSupplierManager.getTokenSupplier().getThreadToken();
            this.digest = token.getDigestContext(alg2);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException(de.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new TokenRuntimeException(nsae.getMessage());
        }
    }

    public int engineGetMacLength() {
        return this.alg.getOutputSize();
    }

    public void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            if (!(key instanceof SecretKeyFacade)) {
                throw new InvalidKeyException("Must use a JSS key");
            }
            SecretKeyFacade facade = (SecretKeyFacade)key;
            this.digest.initHMAC(facade.key);
        }
        catch (DigestException de) {
            throw new InvalidKeyException("DigestException: " + de.getMessage());
        }
    }

    public void engineUpdate(byte input) {
        try {
            this.digest.update(input);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    public void engineUpdate(byte[] input, int offset, int len) {
        try {
            this.digest.update(input, offset, len);
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    public byte[] engineDoFinal() {
        try {
            return this.digest.digest();
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    public void engineReset() {
        try {
            this.digest.reset();
        }
        catch (DigestException de) {
            throw new TokenRuntimeException("DigestException: " + de.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static class HmacSHA512
    extends JSSMacSpi {
        public HmacSHA512() {
            super(HMACAlgorithm.SHA512);
        }
    }

    public static class HmacSHA384
    extends JSSMacSpi {
        public HmacSHA384() {
            super(HMACAlgorithm.SHA384);
        }
    }

    public static class HmacSHA256
    extends JSSMacSpi {
        public HmacSHA256() {
            super(HMACAlgorithm.SHA256);
        }
    }

    public static class HmacSHA1
    extends JSSMacSpi {
        public HmacSHA1() {
            super(HMACAlgorithm.SHA1);
        }
    }
}

