/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

class JSSSecretKeyFactorySpi
extends SecretKeyFactorySpi {
    private KeyGenAlgorithm alg = null;
    private CryptoToken token = null;
    static /* synthetic */ Class class$javax$crypto$spec$DESedeKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$DESKeySpec;
    static /* synthetic */ Class class$javax$crypto$spec$SecretKeySpec;

    private JSSSecretKeyFactorySpi() {
    }

    protected JSSSecretKeyFactorySpi(KeyGenAlgorithm alg2) {
        this.alg = alg2;
        this.token = TokenSupplierManager.getTokenSupplier().getThreadToken();
    }

    private SecretKey generateKeyFromBits(byte[] bits, SymmetricKey.Type keyType) throws NoSuchAlgorithmException, TokenException, InvalidKeySpecException, InvalidAlgorithmParameterException {
        try {
            KeyWrapper wrapper = this.token.getKeyWrapper(KeyWrapAlgorithm.PLAINTEXT);
            wrapper.initUnwrap();
            SymmetricKey symk = wrapper.unwrapSymmetric(bits, keyType, 0);
            return new SecretKeyFacade(symk);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
    }

    private static PBEKeyGenParams makePBEKeyGenParams(PBEKeySpec spec) throws InvalidKeySpecException {
        Class<?> specClass = spec.getClass();
        try {
            Method getSaltMethod = specClass.getMethod("getSalt", null);
            Method getIterationMethod = specClass.getMethod("getIterationCount", null);
            byte[] salt = (byte[])getSaltMethod.invoke((Object)spec, null);
            Integer itCountObj = (Integer)getIterationMethod.invoke((Object)spec, null);
            int iterationCount = itCountObj;
            Password pass = new Password(spec.getPassword());
            PBEKeyGenParams params = new PBEKeyGenParams(pass, salt, iterationCount);
            pass.clear();
            return params;
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (SecurityException se) {
            throw new InvalidKeySpecException("SecurityException calling getMethod() on the key spec's class: " + se.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new InvalidKeySpecException("IllegalAccessException invoking method on PBEKeySpec: " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            String message = "";
            Throwable t = ite.getTargetException();
            if (t != null) {
                message = t.getMessage();
            }
            throw new InvalidKeySpecException("InvocationTargetException invoking method on PBEKeySpec: " + message);
        }
        throw new InvalidKeySpecException("This version of PBEKeySpec is unsupported. It must implement getSalt() and getIterationCount(). The PBEKeySpec in JDK 1.4 works, as does org.mozilla.jss.crypto.PBEKeyGenParams. The PBEKeySpec in JCE 1.2.1 and earlier does NOT work.");
    }

    public SecretKey engineGenerateSecret(KeySpec spec) throws InvalidKeySpecException {
        try {
            if (spec instanceof PBEKeySpec || spec instanceof PBEKeyGenParams) {
                PBEKeyGenParams params = spec instanceof PBEKeySpec ? JSSSecretKeyFactorySpi.makePBEKeyGenParams((PBEKeySpec)spec) : (PBEKeyGenParams)spec;
                KeyGenerator gen = this.token.getKeyGenerator(this.alg);
                gen.initialize(params);
                SymmetricKey symk = gen.generate();
                params.clear();
                return new SecretKeyFacade(symk);
            }
            if (spec instanceof DESedeKeySpec) {
                if (this.alg != KeyGenAlgorithm.DES3) {
                    throw new InvalidKeySpecException("Incorrect KeySpec type (" + spec.getClass().getName() + ") for algorithm (" + this.alg.toString() + ")");
                }
                return this.generateKeyFromBits(((DESedeKeySpec)spec).getKey(), SymmetricKey.Type.DES3);
            }
            if (spec instanceof DESKeySpec) {
                if (this.alg != KeyGenAlgorithm.DES) {
                    throw new InvalidKeySpecException("Incorrect KeySpec type (" + spec.getClass().getName() + ") for algorithm (" + this.alg.toString() + ")");
                }
                return this.generateKeyFromBits(((DESKeySpec)spec).getKey(), SymmetricKey.Type.DES);
            }
            if (spec instanceof SecretKeySpec) {
                SecretKeySpec kspec = (SecretKeySpec)spec;
                SymmetricKey.Type type = SymmetricKey.Type.fromName(kspec.getAlgorithm());
                return this.generateKeyFromBits(kspec.getEncoded(), type);
            }
            throw new InvalidKeySpecException("Unsupported KeySpec: " + spec.getClass().getName());
        }
        catch (TokenException te) {
            throw new TokenRuntimeException(te.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeySpecException("InvalidAlgorithmParameterException: " + iape.getMessage());
        }
        catch (IllegalStateException ise) {
            Assert.notReached("IllegalStateException");
            throw new TokenRuntimeException("IllegalStateException: " + ise.getMessage());
        }
        catch (CharConversionException cce) {
            throw new InvalidKeySpecException("CharConversionException: " + cce.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeySpecException("NoSuchAlgorithmException: " + nsae.getMessage());
        }
    }

    public KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (!(key instanceof SecretKeyFacade)) {
                throw new InvalidKeySpecException("key is not a JSS key");
            }
            SymmetricKey symkey = ((SecretKeyFacade)key).key;
            byte[] keyBits = symkey.getKeyData();
            SymmetricKey.Type keyType = symkey.getType();
            if (keySpec.equals(class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec)) {
                if (keyType != SymmetricKey.Type.DES3) {
                    throw new InvalidKeySpecException("key/spec mismatch: " + keyType + " key, DESede spec");
                }
                return new DESedeKeySpec(keyBits);
            }
            if (keySpec.equals(class$javax$crypto$spec$DESKeySpec == null ? (class$javax$crypto$spec$DESKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.DESKeySpec")) : class$javax$crypto$spec$DESKeySpec)) {
                if (keyType != SymmetricKey.Type.DES) {
                    throw new InvalidKeySpecException("key/spec mismatch: " + keyType + " key, DES spec");
                }
                return new DESKeySpec(keyBits);
            }
            if (keySpec.equals(class$javax$crypto$spec$SecretKeySpec == null ? (class$javax$crypto$spec$SecretKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.SecretKeySpec")) : class$javax$crypto$spec$SecretKeySpec)) {
                return new SecretKeySpec(keyBits, keyType.toString());
            }
            throw new InvalidKeySpecException("Unsupported key spec: " + keySpec.getName());
        }
        catch (SymmetricKey.NotExtractableException nee) {
            throw new InvalidKeySpecException("key is not extractable");
        }
        catch (InvalidKeyException ike) {
            Assert.notReached("Invalid key: " + ike.getMessage());
            throw new InvalidKeySpecException("Invalid key: " + ike.getMessage());
        }
    }

    public SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key instanceof SecretKeyFacade) {
            try {
                SymmetricKey oldkey = ((SecretKeyFacade)key).key;
                CryptoToken owningToken = oldkey.getOwningToken();
                KeyGenerator keygen = this.token.getKeyGenerator(oldkey.getType().getKeyGenAlg());
                SymmetricKey newkey = keygen.clone(oldkey);
                return new SecretKeyFacade(newkey);
            }
            catch (SymmetricKey.NotExtractableException nee) {
                throw new InvalidKeyException("key is not extractable");
            }
            catch (TokenException te) {
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException("Unsupported algorithm: " + nsae.getMessage());
            }
        }
        try {
            byte[] keyBits = key.getEncoded();
            if (keyBits == null) {
                throw new InvalidKeyException("Key is not extractable");
            }
            SymmetricKey.Type keyType = SymmetricKey.Type.fromName(key.getAlgorithm());
            return this.generateKeyFromBits(keyBits, keyType);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException("Unsupported algorithm: " + key.getAlgorithm());
        }
        catch (TokenException te) {
            throw new InvalidKeyException("Token failed to process key: " + te.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidKeyException("Invalid key spec: " + ikse.getMessage());
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidKeyException("Invalid algorithm parameters: " + iape.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            CryptoManager.initialize(".");
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken tok = cm.getInternalCryptoToken();
            cm.setThreadToken(tok);
            KeyGenerator keygen = tok.getKeyGenerator(KeyGenAlgorithm.DES3);
            SymmetricKey symk = keygen.generate();
            SecretKeyFacade origKey = new SecretKeyFacade(symk);
            JSSSecretKeyFactorySpi fact = new JSSSecretKeyFactorySpi(KeyGenAlgorithm.DES3);
            DESedeKeySpec kspec = (DESedeKeySpec)fact.engineGetKeySpec((SecretKey)origKey, class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = JSSSecretKeyFactorySpi.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec);
            SecretKeyFacade newKey = (SecretKeyFacade)fact.engineGenerateSecret(kspec);
            Cipher cipher2 = tok.getCipherContext(EncryptionAlgorithm.DES3_ECB);
            cipher2.initEncrypt(origKey.key);
            String original = "Hello, World!!!!";
            byte[] cipherText = cipher2.doFinal(original.getBytes("UTF-8"));
            System.out.println("ciphertext is " + cipherText.length + " bytes");
            cipher2.initDecrypt(newKey.key);
            byte[] plainText = cipher2.doFinal(cipherText);
            System.out.println("recovered plaintext is " + plainText.length + " bytes");
            String recovered = new String(plainText, "UTF-8");
            System.out.println("Recovered '" + recovered + "'");
            if (!recovered.equals(original)) {
                throw new Exception("recovered string is different from original");
            }
            char[] pw = "foobarpw".toCharArray();
            byte[] salt = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            int iterationCount = 2;
            keygen = tok.getKeyGenerator(PBEAlgorithm.PBE_SHA1_DES3_CBC);
            PBEKeyGenParams jssKeySpec = new PBEKeyGenParams(pw, salt, iterationCount);
            keygen.initialize(jssKeySpec);
            symk = keygen.generate();
            byte[] keydata = symk.getKeyData();
            SecretKeyFactory keyFact = SecretKeyFactory.getInstance("PBEWithSHA1AndDESede", "Mozilla-JSS");
            newKey = (SecretKeyFacade)keyFact.generateSecret(jssKeySpec);
            byte[] newkeydata = newKey.key.getKeyData();
            if (!Arrays.equals(keydata, newkeydata)) {
                throw new Exception("generated PBE keys are different");
            }
            System.out.println("generated PBE keys are the same");
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PBAHmacSHA1
    extends JSSSecretKeyFactorySpi {
        public PBAHmacSHA1() {
            super(KeyGenAlgorithm.PBA_SHA1_HMAC);
        }
    }

    public static class HmacSHA1
    extends JSSSecretKeyFactorySpi {
        public HmacSHA1() {
            super(KeyGenAlgorithm.PBA_SHA1_HMAC);
        }
    }

    public static class PBE_SHA1_RC4_128
    extends JSSSecretKeyFactorySpi {
        public PBE_SHA1_RC4_128() {
            super(PBEAlgorithm.PBE_SHA1_RC4_128);
        }
    }

    public static class PBE_SHA1_DES3_CBC
    extends JSSSecretKeyFactorySpi {
        public PBE_SHA1_DES3_CBC() {
            super(PBEAlgorithm.PBE_SHA1_DES3_CBC);
        }
    }

    public static class PBE_SHA1_DES_CBC
    extends JSSSecretKeyFactorySpi {
        public PBE_SHA1_DES_CBC() {
            super(PBEAlgorithm.PBE_SHA1_DES_CBC);
        }
    }

    public static class PBE_MD5_DES_CBC
    extends JSSSecretKeyFactorySpi {
        public PBE_MD5_DES_CBC() {
            super(PBEAlgorithm.PBE_MD5_DES_CBC);
        }
    }

    public static class RC2
    extends JSSSecretKeyFactorySpi {
        public RC2() {
            super(KeyGenAlgorithm.RC2);
        }
    }

    public static class RC4
    extends JSSSecretKeyFactorySpi {
        public RC4() {
            super(KeyGenAlgorithm.RC4);
        }
    }

    public static class AES
    extends JSSSecretKeyFactorySpi {
        public AES() {
            super(KeyGenAlgorithm.AES);
        }
    }

    public static class DESede
    extends JSSSecretKeyFactorySpi {
        public DESede() {
            super(KeyGenAlgorithm.DESede);
        }
    }

    public static class DES
    extends JSSSecretKeyFactorySpi {
        public DES() {
            super(KeyGenAlgorithm.DES);
        }
    }
}

