/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import org.mozilla.jss.crypto.X509Certificate;

public class SSLSecurityStatus {
    int status;
    String cipher;
    int sessionKeySize;
    int sessionSecretSize;
    String issuer;
    String subject;
    String serialNumber;
    X509Certificate certificate;
    public final int STATUS_NOOPT = -1;
    public final int STATUS_OFF = 0;
    public final int STATUS_ON_HIGH = 1;
    public final int STATUS_ON_LOW = 2;
    public final int STATUS_FORTEZZA = 3;

    public SSLSecurityStatus(int status, String cipher2, int sessionKeySize, int sessionSecretSize, String issuer, String subject, String serialNumber, X509Certificate certificate) {
        String noCert = "no certificate";
        this.status = status;
        this.cipher = cipher2;
        this.sessionKeySize = sessionKeySize;
        this.sessionSecretSize = sessionSecretSize;
        this.certificate = certificate;
        this.issuer = noCert.equals(issuer) ? null : issuer;
        this.subject = noCert.equals(subject) ? null : subject;
        this.serialNumber = serialNumber;
    }

    public boolean isSecurityOn() {
        return this.status > 0;
    }

    public int getSecurityStatus() {
        return this.status;
    }

    public String getCipher() {
        return this.cipher;
    }

    public int getSessionKeySize() {
        return this.sessionKeySize;
    }

    public int getSessionSecretSize() {
        return this.sessionSecretSize;
    }

    public String getRemoteIssuer() {
        return this.issuer;
    }

    public String getRemoteSubject() {
        return this.subject;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public X509Certificate getPeerCertificate() {
        return this.certificate;
    }

    public String toString() {
        String statusString;
        switch (this.status) {
            case -1: {
                statusString = "NOOPT";
                break;
            }
            case 0: {
                statusString = "OFF";
                break;
            }
            case 1: {
                statusString = "ON HIGH";
                break;
            }
            case 2: {
                statusString = "ON LOW";
                break;
            }
            case 3: {
                statusString = "FORTEZZA";
                break;
            }
            default: {
                statusString = "unknown";
            }
        }
        return "Status: " + statusString + "\n" + "Cipher: " + this.cipher + "\n" + "Session key size: " + this.sessionKeySize + "\n" + "Session secret size: " + this.sessionSecretSize + "\n" + "Issuer: " + this.issuer + "\n" + "Subject: " + this.subject + "\n" + "Serial number: " + this.serialNumber + "\n";
    }
}

