/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.PrintOutputStreamWriter;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.ServerHandshakeCB;

public class SSLServer {
    boolean handshakeEventHappened = false;
    boolean doClientAuth = false;
    Hashtable args;
    PrintStream results;
    String versionStr;
    String[] argNames = new String[]{"filename", "port", "filesize", "clientauth", "nickname"};
    String[] values = new String[]{"data1k.txt", "2000", "1024", "false", "SSLServer"};
    private static String htmlHeader = "SSL Server Tester";
    private static String htmlTail = "\n";
    String okay = "okay";
    String failed = "FAILED";
    static final int[] cipherSuites = new int[]{4, 10, 9, 3, 6, 1, 0};

    private boolean isInvalid(String s) {
        return s == null || s.equals("");
    }

    private String getArgument(String key) {
        return (String)this.args.get(key);
    }

    private String cmp(String s1, String s2) {
        if (s1 == s2) {
            return this.okay;
        }
        if (s1 == null) {
            return this.failed;
        }
        if (s1.equals(s2)) {
            return this.okay;
        }
        return this.failed;
    }

    private String cmp(String s1, int s2) {
        return this.cmp(s1, new Integer(s2).toString());
    }

    public void run() {
        try {
            this.results.println(htmlHeader);
            String portStr = this.getArgument("port");
            int port = this.isInvalid(portStr) ? 443 : Integer.valueOf(portStr);
            this.results.println("here");
            String tmpStr = this.getArgument("clientauth");
            if (!this.isInvalid(tmpStr)) {
                this.doClientAuth = !(tmpStr = tmpStr.toLowerCase()).equals("off") && !tmpStr.equals("false") && !tmpStr.equals("0");
            }
            SSLServerSocket l = new SSLServerSocket(port);
            this.results.println("Listening " + l.toString());
            String nickname = this.getArgument("nickname");
            this.results.println("Getting Cert:" + nickname + "");
            l.setServerCertNickname(nickname);
            if (this.doClientAuth) {
                l.setNeedClientAuth(true);
            }
            SSLSocket s = (SSLSocket)l.accept();
            this.results.println("Accepted.");
            this.handleConnection(s);
            s = null;
            l.close();
            l = null;
        }
        catch (Exception e) {
            this.results.println("***** TEST FAILED *****");
            e.printStackTrace(this.results);
            this.results.println("If there is no stack trace, try disabling the JIT and trying again.");
        }
        this.results.println("END OF TEST");
    }

    public void handleConnection(SSLSocket s) throws Exception {
        ServerHandshakeCB listener = null;
        listener = new ServerHandshakeCB(this);
        s.addHandshakeCompletedListener(listener);
        this.results.println("Connected to " + s.toString());
        InputStream in = s.getInputStream();
        byte[] bytes = new byte[4096];
        int totalBytes = 0;
        int numReads = 0;
        try {
            boolean endFound = false;
            block2: while (!endFound && totalBytes < bytes.length) {
                this.results.println("Calling Read.");
                int n = in.read(bytes, totalBytes, bytes.length - totalBytes);
                if (n == -1) {
                    this.results.println("EOF found.");
                    break;
                }
                if (n == 0) {
                    this.results.println("Zero bytes read?");
                    break;
                }
                ++numReads;
                this.results.println("Read " + n + " bytes of data");
                totalBytes += n;
                int i = 0;
                while (i + 3 < bytes.length) {
                    if (bytes[i] == 13 && bytes[i + 1] == 10 && bytes[i + 2] == 13 && bytes[i + 3] == 10) {
                        this.results.println("Empty line found.");
                        endFound = true;
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.results.println("IOException while reading from pipe?  Actually got " + totalBytes + " bytes total");
            e.printStackTrace(this.results);
            this.results.println("");
            throw e;
        }
        this.results.println("Number of read() calls: " + numReads);
        this.results.println("Total bytes read:       " + totalBytes);
        String msg = null;
        if (totalBytes > 0) {
            msg = new String(bytes, 0, totalBytes, "8859_1");
            this.results.println("Request received:");
            this.results.println(msg);
            this.results.println("");
        }
        SSLSecurityStatus status = s.getStatus();
        this.results.println("Security status of session:");
        this.results.println(status.toString());
        this.results.println("Handshake callback event happened: " + (this.handshakeEventHappened ? this.okay : this.failed));
        OutputStream os = s.getOutputStream();
        PrintOutputStreamWriter out = new PrintOutputStreamWriter(os);
        os = null;
        String reply = "HTTP/1.0 200 OK\r\nServer: Netscape-Enterprise/2.0a\r\nDate: Tue, 01 Apr 1998 22:10:05 GMT\r\nContent-type: text/plain\r\n\r\n" + msg;
        out.println(reply);
        in.close();
        in = null;
        if (listener != null) {
            s.removeHandshakeCompletedListener(listener);
            listener = null;
        }
        out.close();
        out = null;
        s.close();
        s = null;
    }

    private String escapeHTML(String s) {
        StringBuffer result = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block5;
                }
                case '>': {
                    result.append("&gt;");
                    continue block5;
                }
                case '&': {
                    result.append("&amp;");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public SSLServer(PrintStream ps, String verStr) {
        this.args = new Hashtable();
        this.results = ps;
        this.versionStr = verStr;
        for (int i = 0; i < this.argNames.length; ++i) {
            String value = this.values[i];
            if (value == null) continue;
            this.args.put(this.argNames[i], value);
        }
    }

    public static void main(String[] argv) throws Exception {
        int i;
        System.out.println("SSLServer started\n");
        try {
            CryptoManager.initialize(".");
        }
        catch (KeyDatabaseException kdbe) {
            System.out.println("Couldn't open the key database\n");
            return;
        }
        catch (CertDatabaseException cdbe) {
            System.out.println("Couldn't open the certificate database");
            return;
        }
        catch (AlreadyInitializedException aie) {
            System.out.println("CryptoManager already initialized???");
            return;
        }
        catch (GeneralSecurityException e) {
            System.out.println("General security exception while initializing");
            return;
        }
        SSLServerSocket.configServerSessionIDCache(10, 0, 0, null);
        for (i = 65281; i <= 65287; ++i) {
            SSLSocket.setCipherPreferenceDefault(i, true);
        }
        i = 0;
        while (cipherSuites[i] != 0) {
            SSLSocket.setCipherPreferenceDefault(cipherSuites[i], true);
            ++i;
        }
        SSLServer x = new SSLServer(System.out, "Stand alone Ver 0.01");
        x.run();
    }
}

