/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SocketBase;
import org.mozilla.jss.ssl.SocketProxy;

public class SSLServerSocket
extends ServerSocket {
    private SocketProxy sockProxy = null;
    private boolean handshakeAsClient = false;
    private SocketBase base = new SocketBase();
    private boolean isClosed = false;
    private boolean inAccept = false;
    private Object acceptLock = new Object();
    public static final int DEFAULT_BACKLOG = 50;
    private static InetAddress anyLocalAddr;
    private static final String UNIX_TEMP_DIR = "/tmp";
    private static final String WINDOWS_TEMP_DIR = "\\temp";

    public SSLServerSocket(int port) throws IOException {
        this(port, 50, null);
    }

    public SSLServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public SSLServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this(port, backlog, bindAddr, null);
    }

    public SSLServerSocket(int port, int backlog, InetAddress bindAddr, SSLCertificateApprovalCallback certApprovalCallback) throws IOException {
        this(port, backlog, bindAddr, certApprovalCallback, false);
    }

    public SSLServerSocket(int port, int backlog, InetAddress bindAddr, SSLCertificateApprovalCallback certApprovalCallback, boolean reuseAddr) throws IOException {
        super(0);
        super.close();
        this.sockProxy = new SocketProxy(this.base.socketCreate(this, certApprovalCallback, null));
        this.base.setProxy(this.sockProxy);
        this.setReuseAddress(reuseAddr);
        if (bindAddr == null) {
            bindAddr = anyLocalAddr;
        }
        byte[] bindAddrBA = null;
        if (bindAddr != null) {
            bindAddrBA = bindAddr.getAddress();
        }
        this.base.socketBind(bindAddrBA, port);
        this.socketListen(backlog);
    }

    private native void socketListen(int var1) throws SocketException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket accept() throws IOException {
        Object object = this.acceptLock;
        synchronized (object) {
            SSLServerSocket sSLServerSocket;
            SSLServerSocket sSLServerSocket2 = this;
            synchronized (sSLServerSocket2) {
                if (this.isClosed) {
                    throw new IOException("SSLServerSocket has been closed, and cannot be reused.");
                }
                this.inAccept = true;
            }
            SSLSocket s = new SSLSocket();
            try {
                byte[] socketPointer = null;
                socketPointer = this.socketAccept(s, this.base.getTimeout(), this.handshakeAsClient);
                SocketProxy sp = new SocketProxy(socketPointer);
                s.setSockProxy(sp);
                Object var6_6 = null;
                sSLServerSocket = this;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                SSLServerSocket sSLServerSocket3 = this;
                synchronized (sSLServerSocket3) {
                    this.inAccept = false;
                }
                throw throwable;
            }
            synchronized (sSLServerSocket) {
                this.inAccept = false;
            }
            return s;
        }
    }

    public void setSoTimeout(int timeout) {
        this.base.setTimeout(timeout);
    }

    public int getSoTimeout() {
        return this.base.getTimeout();
    }

    public native void setReuseAddress(boolean var1) throws SocketException;

    public native boolean getReuseAddress() throws SocketException;

    private native void abortAccept() throws SocketException;

    private native byte[] socketAccept(SSLSocket var1, int var2, boolean var3) throws SocketException, SocketTimeoutException;

    public static native void clearSessionCache();

    protected void finalize() throws Throwable {
        this.close();
    }

    public int getLocalPort() {
        return this.base.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.sockProxy == null) {
                return;
            }
            if (this.inAccept) {
                this.abortAccept();
            }
        }
        object = this.acceptLock;
        synchronized (object) {
            this.base.close();
            this.sockProxy = null;
            this.base.setProxy(null);
        }
    }

    public static native void configServerSessionIDCache(int var0, int var1, int var2, String var3) throws SocketException;

    public void setServerCertNickname(String nick) throws SocketException {
        try {
            this.setServerCert(CryptoManager.getInstance().findCertByNickname(nick));
        }
        catch (CryptoManager.NotInitializedException nie) {
            throw new SocketException("CryptoManager not initialized");
        }
        catch (ObjectNotFoundException onfe) {
            throw new SocketException("Object not found: " + onfe);
        }
        catch (TokenException te) {
            throw new SocketException("Token Exception: " + te);
        }
    }

    public native void setServerCert(X509Certificate var1) throws SocketException;

    public void requestClientAuth(boolean b) throws SocketException {
        this.base.requestClientAuth(b);
    }

    public void setNeedClientAuth(boolean b) throws SocketException {
        this.base.requestClientAuth(b);
    }

    public void setNeedClientAuthNoExpiryCheck(boolean b) throws SocketException {
        this.base.requestClientAuthNoExpiryCheck(b);
    }

    public void enableSSL2(boolean enable) throws SocketException {
        this.base.enableSSL2(enable);
    }

    public void enableSSL3(boolean enable) throws SocketException {
        this.base.enableSSL3(enable);
    }

    public void enableTLS(boolean enable) throws SocketException {
        this.base.enableTLS(enable);
    }

    public void enableSessionTickets(boolean enable) throws SocketException {
        this.base.enableSessionTickets(enable);
    }

    public void enableRenegotiation(int mode) throws SocketException {
        if (mode < 24 || mode > 27) {
            throw new SocketException("Incorrect input value.");
        }
        this.base.enableRenegotiation(mode);
    }

    public void enableRequireSafeNegotiation(boolean enable) throws SocketException {
        this.base.enableRequireSafeNegotiation(enable);
    }

    public void bypassPKCS11(boolean enable) throws SocketException {
        this.base.bypassPKCS11(enable);
    }

    public void enableRollbackDetection(boolean enable) throws SocketException {
        this.base.enableRollbackDetection(enable);
    }

    public void enableStepDown(boolean enable) throws SocketException {
        this.base.enableStepDown(enable);
    }

    public void enableFDX(boolean enable) throws SocketException {
        this.base.enableFDX(enable);
    }

    public void enableV2CompatibleHello(boolean enable) throws SocketException {
        this.base.enableV2CompatibleHello(enable);
    }

    public String getSSLOptions() {
        return this.base.getSSLOptions();
    }

    public InetAddress getInetAddress() {
        return this.base.getLocalAddress();
    }

    public void requireClientAuth(boolean require, boolean onRedo) throws SocketException {
        this.base.requireClientAuth(require, onRedo);
    }

    public void requireClientAuth(int mode) throws SocketException {
        if (mode < 18 || mode > 21) {
            throw new SocketException("Incorrect input value.");
        }
        this.base.requireClientAuth(mode);
    }

    public void setClientCertNickname(String nick) throws SocketException {
        this.base.setClientCertNickname(nick);
    }

    public void setClientCert(X509Certificate cert) throws SocketException {
        this.base.setClientCert(cert);
    }

    public void setUseClientMode(boolean b) {
        this.handshakeAsClient = b;
    }

    public void useCache(boolean b) throws SocketException {
        this.base.useCache(b);
    }

    public String toString() {
        try {
            InetAddress inetAddr = this.getInetAddress();
            int localPort = this.getLocalPort();
            StringBuffer buf = new StringBuffer();
            buf.append("SSLServerSocket[addr=");
            buf.append(inetAddr);
            buf.append(",localport=");
            buf.append(localPort);
            buf.append("]");
            return buf.toString();
        }
        catch (Exception e) {
            return "Exception caught in toString(): " + e.getMessage();
        }
    }

    static {
        try {
            anyLocalAddr = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

