/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SocketProxy;
import org.mozilla.jss.util.Assert;

class SocketBase {
    private SocketProxy sockProxy;
    private int timeout;
    static final int SSL_ENABLE_SSL2 = 0;
    static final int SSL_ENABLE_SSL3 = 1;
    static final int SSL_ENABLE_TLS = 2;
    static final int TCP_NODELAY = 3;
    static final int SO_KEEPALIVE = 4;
    static final int PR_SHUTDOWN_RCV = 5;
    static final int PR_SHUTDOWN_SEND = 6;
    static final int SSL_REQUIRE_CERTIFICATE = 7;
    static final int SSL_REQUEST_CERTIFICATE = 8;
    static final int SSL_NO_CACHE = 9;
    static final int SSL_POLICY_DOMESTIC = 10;
    static final int SSL_POLICY_EXPORT = 11;
    static final int SSL_POLICY_FRANCE = 12;
    static final int SSL_BYPASS_PKCS11 = 13;
    static final int SSL_ROLLBACK_DETECTION = 14;
    static final int SSL_NO_STEP_DOWN = 15;
    static final int SSL_ENABLE_FDX = 16;
    static final int SSL_V2_COMPATIBLE_HELLO = 17;
    static final int SSL_REQUIRE_NEVER = 18;
    static final int SSL_REQUIRE_ALWAYS = 19;
    static final int SSL_REQUIRE_FIRST_HANDSHAKE = 20;
    static final int SSL_REQUIRE_NO_ERROR = 21;
    static final int SSL_ENABLE_SESSION_TICKETS = 22;
    static final int SSL_ENABLE_RENEGOTIATION = 23;
    static final int SSL_RENEGOTIATE_NEVER = 24;
    static final int SSL_RENEGOTIATE_UNRESTRICTED = 25;
    static final int SSL_RENEGOTIATE_REQUIRES_XTN = 26;
    static final int SSL_RENEGOTIATE_TRANSITIONAL = 27;
    static final int SSL_REQUIRE_SAFE_NEGOTIATION = 28;
    private boolean requestingClientAuth = false;
    static /* synthetic */ Class class$java$lang$String;

    SocketBase() {
    }

    int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    void setProxy(SocketProxy sockProxy) {
        this.sockProxy = sockProxy;
    }

    native byte[] socketCreate(Object var1, SSLCertificateApprovalCallback var2, SSLClientCertificateSelectionCallback var3, Socket var4, String var5) throws SocketException;

    byte[] socketCreate(Object socketObject, SSLCertificateApprovalCallback certApprovalCallback, SSLClientCertificateSelectionCallback clientCertSelectionCallback) throws SocketException {
        return this.socketCreate(socketObject, certApprovalCallback, clientCertSelectionCallback, null, null);
    }

    native void socketBind(byte[] var1, int var2) throws SocketException;

    void close() throws IOException {
        this.socketClose();
    }

    native void socketClose() throws IOException;

    void requestClientAuth(boolean b) throws SocketException {
        this.requestingClientAuth = b;
        this.setSSLOption(8, b);
    }

    public void requestClientAuthNoExpiryCheck(boolean b) throws SocketException {
        this.requestingClientAuth = b;
        this.requestClientAuthNoExpiryCheckNative(b);
    }

    private native void requestClientAuthNoExpiryCheckNative(boolean var1) throws SocketException;

    void enableSSL2(boolean enable) throws SocketException {
        this.setSSLOption(0, enable);
    }

    void enableSSL3(boolean enable) throws SocketException {
        this.setSSLOption(1, enable);
    }

    void enableTLS(boolean enable) throws SocketException {
        this.setSSLOption(2, enable);
    }

    void enableSessionTickets(boolean enable) throws SocketException {
        this.setSSLOption(22, enable);
    }

    void enableRenegotiation(int mode) throws SocketException {
        this.setSSLOptionMode(23, mode);
    }

    void enableRequireSafeNegotiation(boolean enable) throws SocketException {
        this.setSSLOption(28, enable);
    }

    void bypassPKCS11(boolean enable) throws SocketException {
        this.setSSLOption(13, enable);
    }

    void enableRollbackDetection(boolean enable) throws SocketException {
        this.setSSLOption(14, enable);
    }

    void enableStepDown(boolean enable) throws SocketException {
        this.setSSLOption(15, enable);
    }

    void enableFDX(boolean enable) throws SocketException {
        this.setSSLOption(16, enable);
    }

    void enableV2CompatibleHello(boolean enable) throws SocketException {
        this.setSSLOption(17, enable);
    }

    void setSSLOption(int option, boolean on) throws SocketException {
        this.setSSLOption(option, on ? 1 : 0);
    }

    native void setSSLOption(int var1, int var2) throws SocketException;

    native void setSSLOptionMode(int var1, int var2) throws SocketException;

    native int getSSLOption(int var1) throws SocketException;

    public String getSSLOptions() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("SSL Options configured for this SSLSocket:");
            buf.append("\nSSL_ENABLE_SSL2" + (this.getSSLOption(0) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_SSL3" + (this.getSSLOption(1) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_TLS" + (this.getSSLOption(2) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_REQUIRE_CERTIFICATE");
            switch (this.getSSLOption(7)) {
                case 0: {
                    buf.append("=Never");
                    break;
                }
                case 1: {
                    buf.append("=Always");
                    break;
                }
                case 2: {
                    buf.append("=First Handshake");
                    break;
                }
                case 3: {
                    buf.append("=No Error");
                    break;
                }
                default: {
                    buf.append("=Report JSS Bug this option has a status.");
                }
            }
            buf.append("\nSSL_REQUEST_CERTIFICATE" + (this.getSSLOption(8) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_NO_CACHE" + (this.getSSLOption(9) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_BYPASS_PKCS11" + (this.getSSLOption(13) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ROLLBACK_DETECTION" + (this.getSSLOption(14) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_NO_STEP_DOWN" + (this.getSSLOption(15) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_FDX" + (this.getSSLOption(16) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_V2_COMPATIBLE_HELLO" + (this.getSSLOption(17) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_SESSION_TICKETS" + (this.getSSLOption(22) != 0 ? "=on" : "=off"));
            buf.append("\nSSL_ENABLE_RENEGOTIATION");
            switch (this.getSSLOption(23)) {
                case 0: {
                    buf.append("=SSL_RENEGOTIATE_NEVER");
                    break;
                }
                case 1: {
                    buf.append("=SSL_RENEGOTIATE_UNRESTRICTED");
                    break;
                }
                case 2: {
                    buf.append("=SSL_RENEGOTIATE_REQUIRES_XTN");
                    break;
                }
                case 3: {
                    buf.append("=SSL_RENEGOTIATE_TRANSITIONAL");
                    break;
                }
                default: {
                    buf.append("=Report JSS Bug this option has a status.");
                }
            }
            buf.append("\nSSL_REQUIRE_SAFE_NEGOTIATION" + (this.getSSLOption(28) != 0 ? "=on" : "=off"));
        }
        catch (SocketException e) {
            buf.append("\ngetSSLOptions exception " + e.getMessage());
        }
        return buf.toString();
    }

    private static InetAddress convertIntToInetAddress(int intAddr) {
        InetAddress in;
        int[] addr = new int[]{intAddr >>> 24 & 0xFF, intAddr >>> 16 & 0xFF, intAddr >>> 8 & 0xFF, intAddr & 0xFF};
        try {
            in = InetAddress.getByName(addr[0] + "." + addr[1] + "." + addr[2] + "." + addr[3]);
        }
        catch (UnknownHostException e) {
            in = null;
        }
        return in;
    }

    InetAddress getInetAddress() {
        try {
            return SocketBase.convertIntToInetAddress(this.getPeerAddressNative());
        }
        catch (SocketException e) {
            return null;
        }
    }

    private native int getPeerAddressNative() throws SocketException;

    InetAddress getLocalAddress() {
        try {
            return SocketBase.convertIntToInetAddress(this.getLocalAddressNative());
        }
        catch (SocketException e) {
            return null;
        }
    }

    private native int getLocalAddressNative() throws SocketException;

    public int getLocalPort() {
        try {
            return this.getLocalPortNative();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    private native int getLocalPortNative() throws SocketException;

    void requireClientAuth(boolean require, boolean onRedo) throws SocketException {
        if (require && !this.requestingClientAuth) {
            this.requestClientAuth(true);
        }
        this.setSSLOption(7, require ? (onRedo ? 1 : 2) : 0);
    }

    void requireClientAuth(int mode) throws SocketException {
        if (mode > 0 && !this.requestingClientAuth) {
            this.requestClientAuth(true);
        }
        this.setSSLOptionMode(7, mode);
    }

    public void setClientCertNickname(String nick) throws SocketException {
        try {
            this.setClientCert(CryptoManager.getInstance().findCertByNickname(nick));
        }
        catch (CryptoManager.NotInitializedException nie) {
            throw new SocketException("CryptoManager not initialized");
        }
        catch (ObjectNotFoundException onfe) {
            throw new SocketException("Object not found: " + onfe);
        }
        catch (TokenException te) {
            throw new SocketException("Token Exception: " + te);
        }
    }

    native void setClientCert(X509Certificate var1) throws SocketException;

    void useCache(boolean b) throws SocketException {
        this.setSSLOption(9, !b);
    }

    static Throwable processExceptions(Throwable topException, Throwable bottomException) {
        try {
            StringBuffer strBuf = new StringBuffer(topException.toString());
            if (bottomException != null) {
                strBuf.append(" --> ");
                strBuf.append(bottomException.toString());
            }
            Class<?> excepClass = topException.getClass();
            Class stringClass = class$java$lang$String == null ? (class$java$lang$String = SocketBase.class$("java.lang.String")) : class$java$lang$String;
            Constructor<?> cons = excepClass.getConstructor(stringClass);
            return (Throwable)cons.newInstance(strBuf.toString());
        }
        catch (Exception e) {
            Assert.notReached("Problem constructing exception container");
            return topException;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

