/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class TestCertApprovalCallback
implements SSLCertificateApprovalCallback {
    public boolean approve(X509Certificate servercert, SSLCertificateApprovalCallback.ValidityStatus status) {
        System.out.println("in TestCertApprovalCallback.approve()");
        System.out.println("Peer cert details: \n     subject: " + ((Object)servercert.getSubjectDN()).toString() + "\n     issuer:  " + ((Object)servercert.getIssuerDN()).toString() + "\n     serial:  " + servercert.getSerialNumber().toString());
        boolean trust_the_server_cert = false;
        Enumeration errors = status.getReasons();
        int i = 0;
        while (errors.hasMoreElements()) {
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            System.out.println("item " + ++i + " reason=" + item.getReason() + " depth=" + item.getDepth());
            PK11Cert cert = item.getCert();
            if (item.getReason() == -8172) {
                trust_the_server_cert = true;
            }
            System.out.println(" cert details: \n     subject: " + ((Object)cert.getSubjectDN()).toString() + "\n     issuer:  " + ((Object)cert.getIssuerDN()).toString() + "\n     serial:  " + cert.getSerialNumber().toString());
        }
        if (trust_the_server_cert) {
            System.out.println("importing certificate.");
            try {
                InternalCertificate newcert = CryptoManager.getInstance().importCertToPerm(servercert, "testnick");
                newcert.setSSLTrust(3);
            }
            catch (Exception e) {
                System.out.println("thrown exception: " + e);
            }
        }
        return true;
    }
}

