/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.util.Debug;

public class DigestTest {
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    static final String[] JSS_Digest_Algs = new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"};

    public static boolean messageDigestCompare(String alg2, byte[] toBeDigested) throws Exception {
        boolean bTested = false;
        MessageDigest mozillaDigest = MessageDigest.getInstance(alg2, MOZ_PROVIDER_NAME);
        byte[] mozillaDigestOut = mozillaDigest.digest(toBeDigested);
        Provider[] providers = Security.getProviders("MessageDigest." + alg2);
        String provider = null;
        for (int i = 0; i < providers.length; ++i) {
            provider = providers[i].getName();
            if (provider.equals(MOZ_PROVIDER_NAME)) continue;
            MessageDigest otherDigest = MessageDigest.getInstance(alg2, provider);
            byte[] otherDigestOut = otherDigest.digest(toBeDigested);
            if (MessageDigest.isEqual(mozillaDigestOut, otherDigestOut)) {
                System.out.println(provider + " and " + MOZ_PROVIDER_NAME + " give same " + alg2 + " message digests");
                bTested = true;
                continue;
            }
            throw new Exception("ERROR: " + provider + " and " + MOZ_PROVIDER_NAME + " give different " + alg2 + " message digests");
        }
        return bTested;
    }

    public static boolean testJSSDigest(String alg2, byte[] toBeDigested) throws Exception {
        MessageDigest mozillaDigest = MessageDigest.getInstance(alg2, MOZ_PROVIDER_NAME);
        byte[] mozillaDigestOut = mozillaDigest.digest(toBeDigested);
        if (mozillaDigestOut.length != mozillaDigest.getDigestLength()) {
            throw new Exception("ERROR: digest output size is " + mozillaDigestOut.length + ", should be " + mozillaDigest.getDigestLength());
        }
        System.out.println(mozillaDigest.getAlgorithm() + " " + " digest output size is " + mozillaDigestOut.length);
        return true;
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 2) {
                System.out.println("Usage: java org.mozilla.jss.tests.DigestTest <dbdir> <File>");
                System.exit(1);
            }
            String dbdir = argv[0];
            FileInputStream fis = new FileInputStream(argv[1]);
            byte[] toBeDigested = new byte[fis.available()];
            int read = fis.read(toBeDigested);
            System.out.println(read + " bytes to be digested");
            CryptoManager.initialize(dbdir);
            Debug.setLevel(10);
            String javaVersion = System.getProperty("java.version");
            System.out.println("The Java version is: " + javaVersion);
            for (int i = 0; i < JSS_Digest_Algs.length; ++i) {
                if (DigestTest.messageDigestCompare(JSS_Digest_Algs[i], toBeDigested)) continue;
                DigestTest.testJSSDigest(JSS_Digest_Algs[i], toBeDigested);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

