/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.tests.FilePasswordCallback;

public class FipsTest {
    public static void main(String[] args) {
        try {
            CryptoToken tok;
            if (args.length < 2) {
                System.out.println("Usage: FipsTest <dbdir> <fipsmode enter: enable OR disable OR chkfips > <password file>");
                return;
            }
            String dbdir = args[0];
            String fipsmode = args[1];
            String password = "";
            if (args.length == 3) {
                password = args[2];
                System.out.println("The password file " + password);
            }
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(dbdir);
            System.out.println("output of Initilization values ");
            System.out.println("Manufacturer ID: " + vals.getManufacturerID());
            System.out.println("Library: " + vals.getLibraryDescription());
            System.out.println("Internal Slot: " + vals.getInternalSlotDescription());
            System.out.println("Internal Token: " + vals.getInternalTokenDescription());
            System.out.println("Key Storage Slot: " + vals.getFIPSKeyStorageSlotDescription());
            System.out.println("Key Storage Token: " + vals.getInternalKeyStorageTokenDescription());
            System.out.println("FIPS Slot: " + vals.getFIPSSlotDescription());
            System.out.println("FIPS Key Storage: " + vals.getFIPSKeyStorageSlotDescription());
            vals.fipsMode = fipsmode.equalsIgnoreCase("enable") ? CryptoManager.InitializationValues.FIPSMode.ENABLED : (fipsmode.equalsIgnoreCase("disable") ? CryptoManager.InitializationValues.FIPSMode.DISABLED : CryptoManager.InitializationValues.FIPSMode.UNCHANGED);
            CryptoManager.initialize(vals);
            CryptoManager cm = CryptoManager.getInstance();
            if (cm.FIPSEnabled()) {
                System.out.println("\n\t\tFIPS enabled\n");
            } else {
                System.out.println("\n\t\tFIPS not enabled\n");
            }
            Enumeration items = cm.getModules();
            System.out.println("\nListing of Modules:");
            while (items.hasMoreElements()) {
                System.out.println("\t" + ((PK11Module)items.nextElement()).getName());
            }
            items = cm.getAllTokens();
            System.out.println("\nAll Tokens:");
            while (items.hasMoreElements()) {
                tok = (CryptoToken)items.nextElement();
                System.out.print("\t" + tok.getName());
                if (tok.needsLogin()) {
                    System.out.println("\t - Needs login.\n");
                    continue;
                }
                System.out.println("\t - Does not need login.\n");
            }
            items = cm.getExternalTokens();
            System.out.println("\nExternal Tokens:");
            while (items.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)items.nextElement()).getName());
            }
            String tokenName = cm.FIPSEnabled() ? vals.getFIPSSlotDescription() : vals.getInternalKeyStorageTokenDescription();
            tokenName = tokenName.substring(0, 32);
            tokenName = tokenName.trim();
            System.out.println("\nFinding the Internal Key Storage token: " + tokenName);
            tok = cm.getTokenByName(tokenName);
            if (((PK11Token)tok).isInternalKeyStorageToken() && ((Object)tok).equals(cm.getInternalKeyStorageToken())) {
                System.out.println("Good, " + tok.getName() + ", knows it is " + "the internal Key Storage Token");
            } else {
                System.out.println("ERROR: " + tok.getName() + ", doesn't know" + " it is the internal key storage token");
            }
            if (!password.equals("")) {
                System.out.println("logging in to the Token: " + tok.getName());
                FilePasswordCallback cb = new FilePasswordCallback(password);
                tok.login(cb);
                System.out.println("logged in to the Token: " + tok.getName());
            }
            tokenName = cm.FIPSEnabled() ? vals.getFIPSSlotDescription() : vals.getInternalTokenDescription();
            tokenName = tokenName.substring(0, 32);
            tokenName = tokenName.trim();
            System.out.println("\nFinding the Internal Crypto token: " + tokenName);
            tok = cm.getTokenByName(tokenName);
            if (((PK11Token)tok).isInternalCryptoToken() && ((Object)tok).equals(cm.getInternalCryptoToken())) {
                System.out.println("Good, " + tok.getName() + ", knows it is the internal Crypto token");
            } else {
                System.out.println("ERROR: " + tok.getName() + ", doesn't know that it is the internal Crypto token");
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

