/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.tests.FilePasswordCallback;

public class HMACTest {
    private CryptoManager cm;
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    static final String[] JSS_HMAC_Algs = new String[]{"HmacSHA1", "HmacSHA256", "HmacSHA384", "HmacSHA512"};

    public HMACTest(String[] argv) throws Exception {
        if (argv.length < 1) {
            System.out.println("Usage: java org.mozilla.jss.tests.HMACTest <dbdir> [password file only needed in FIPS mode]");
            System.exit(1);
        }
        CryptoManager.initialize(argv[0]);
        this.cm = CryptoManager.getInstance();
        if (this.cm.FIPSEnabled()) {
            System.out.println("\n\t\tFIPS enabled.\n");
            if (argv.length == 2) {
                CryptoToken tok = this.cm.getInternalCryptoToken();
                System.out.println("logging in to token: " + tok.getName());
                FilePasswordCallback cb = new FilePasswordCallback(argv[1]);
                tok.login(cb);
            }
        }
    }

    public boolean compareHMAC(String alg2, SecretKeyFacade sk, String clearText) throws Exception {
        boolean bTested = false;
        Mac mozillaHmac = Mac.getInstance(alg2, MOZ_PROVIDER_NAME);
        mozillaHmac.init(sk);
        mozillaHmac.update(clearText.getBytes());
        byte[] mozillaHmacOut = mozillaHmac.doFinal();
        Provider[] providers = Security.getProviders("Mac." + alg2);
        String provider = null;
        for (int i = 0; i < providers.length; ++i) {
            provider = providers[i].getName();
            if (provider.equals(MOZ_PROVIDER_NAME)) continue;
            Mac providerHmac = Mac.getInstance(alg2, provider);
            providerHmac.init(sk);
            providerHmac.update(clearText.getBytes());
            byte[] providerHmacOut = providerHmac.doFinal();
            if (MessageDigest.isEqual(mozillaHmacOut, providerHmacOut)) {
                System.out.println(provider + " and " + MOZ_PROVIDER_NAME + " give same " + alg2);
                bTested = true;
                continue;
            }
            throw new Exception("ERROR: " + provider + " and " + MOZ_PROVIDER_NAME + " give different " + alg2);
        }
        return bTested;
    }

    public void doHMAC(String alg2, SecretKeyFacade sk, String clearText) throws Exception {
        Mac mozillaHmac = Mac.getInstance(alg2, MOZ_PROVIDER_NAME);
        mozillaHmac.init(sk);
        byte[] mozillaHmacOut = mozillaHmac.doFinal(clearText.getBytes());
        if (mozillaHmacOut.length != mozillaHmac.getMacLength()) {
            throw new Exception("ERROR: hmac output size is " + mozillaHmacOut.length + ", should be " + mozillaHmac.getMacLength());
        }
        System.out.println("Mozilla-JSS supports " + mozillaHmac.getAlgorithm() + "  and the output size is " + mozillaHmac.getMacLength());
    }

    public boolean fipsMode() {
        return this.cm.FIPSEnabled();
    }

    public static void main(String[] argv) {
        try {
            HMACTest hmacTest = new HMACTest(argv);
            byte[] salt = new byte[]{10, 109, 7, -70, 30, -67, 114, -15};
            int iterationCount = 7;
            PBEKeySpec pbeKeySpec = new PBEKeySpec("password".toCharArray(), salt, iterationCount);
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithSHA1AndDES3", MOZ_PROVIDER_NAME);
            SecretKeyFacade sk = (SecretKeyFacade)keyFac.generateSecret(pbeKeySpec);
            String clearText = new String("FireFox and Thunderbird rule");
            for (int i = 0; i < JSS_HMAC_Algs.length; ++i) {
                if (hmacTest.fipsMode()) {
                    if (JSS_HMAC_Algs[i].equals("HmacSHA512")) continue;
                    hmacTest.doHMAC(JSS_HMAC_Algs[i], sk, clearText);
                    continue;
                }
                if (hmacTest.compareHMAC(JSS_HMAC_Algs[i], sk, clearText)) continue;
                hmacTest.doHMAC(JSS_HMAC_Algs[i], sk, clearText);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

