/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Debug;

public class JCASigTest {
    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.JCASigTest <dbdir> <passwordFile>");
    }

    public static void sigTest(String alg2, KeyPair keyPair) {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        try {
            Signature signer = Signature.getInstance(alg2);
            System.out.println("Created a signing context");
            Provider provider = signer.getProvider();
            System.out.println("The provider used for the signer " + provider.getName() + " and the algorithm was " + alg2);
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            signer.initSign((PrivateKey)keyPair.getPrivate());
            System.out.println("initialized the signing operation");
            signer.update(data);
            System.out.println("updated signature with data");
            byte[] signature = signer.sign();
            System.out.println("Successfully signed!");
            signer.initVerify(keyPair.getPublic());
            System.out.println("initialized verification");
            signer.update(data);
            System.out.println("updated verification with data");
            if (signer.verify(signature)) {
                System.out.println("Signature Verified Successfully!");
            } else {
                System.out.println("ERROR: Signature failed to verify.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            JCASigTest.usage();
            System.exit(1);
        }
        String dbdir = args[0];
        String file = args[1];
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(dbdir);
            vals.removeSunProvider = true;
            CryptoManager.initialize(vals);
            CryptoManager manager = CryptoManager.getInstance();
            manager.setPasswordCallback(new FilePasswordCallback(file));
            Debug.setLevel(10);
            Provider[] providers = Security.getProviders();
            for (int i = 0; i < providers.length; ++i) {
                System.out.println("Provider " + i + ": " + providers[i].getName());
            }
            KeyPairGenerator kpgen = KeyPairGenerator.getInstance("RSA");
            kpgen.initialize(1024);
            KeyPair keyPair = kpgen.generateKeyPair();
            Provider provider = kpgen.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            JCASigTest.sigTest("MD5/RSA", keyPair);
            JCASigTest.sigTest("MD2/RSA", keyPair);
            JCASigTest.sigTest("SHA-1/RSA", keyPair);
            JCASigTest.sigTest("SHA-256/RSA", keyPair);
            JCASigTest.sigTest("SHA-384/RSA", keyPair);
            JCASigTest.sigTest("SHA-512/RSA", keyPair);
            kpgen = KeyPairGenerator.getInstance("DSA");
            kpgen.initialize(1024);
            keyPair = kpgen.generateKeyPair();
            provider = kpgen.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            JCASigTest.sigTest("SHA-1/DSA", keyPair);
            kpgen = KeyPairGenerator.getInstance("EC");
            kpgen.initialize(256);
            keyPair = kpgen.generateKeyPair();
            provider = kpgen.getProvider();
            System.out.println("The provider used to Generate the Keys was " + provider.getName());
            System.out.println("provider info " + provider.getInfo());
            if (!provider.getName().equalsIgnoreCase("Mozilla-JSS")) {
                System.out.println("Mozilla-JSS is supposed to be the default provider for JCASigTest");
                System.exit(1);
            }
            JCASigTest.sigTest("SHA-1/EC", keyPair);
            JCASigTest.sigTest("SHA-256/EC", keyPair);
            JCASigTest.sigTest("SHA-384/EC", keyPair);
            JCASigTest.sigTest("SHA-512/EC", keyPair);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

