/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JSSE_SSLClient {
    private String sslRevision = "TLS";
    private String host = null;
    private int port = -1;
    private String cipherName = null;
    private String path = null;
    private int debug_level = 0;
    private String EOF = "test";
    private String keystoreLoc = "rsa.pfx";
    private SSLSocketFactory factory = null;
    private ArrayList ciphersToTest = new ArrayList();
    private ArrayList h_ciphers = new ArrayList();
    private ArrayList f_ciphers = new ArrayList();
    private boolean bVerbose = false;
    private boolean bFipsMode = false;

    public void setSslRevision(String fSslRevision) {
        if (!fSslRevision.equals("TLS") && !fSslRevision.equals("SSLv3")) {
            System.out.println("type must equal 'TLS' or 'SSLv3'\n");
            System.exit(1);
        }
        this.sslRevision = fSslRevision;
    }

    public void setHost(String fHost) {
        this.host = fHost;
    }

    public void setPort(int fPort) {
        this.port = fPort;
    }

    public void setCipherSuite(String fCipherSuite) {
        this.cipherName = fCipherSuite;
    }

    public void setKeystoreLoc(String fKeystoreLoc) {
        this.keystoreLoc = fKeystoreLoc + "/" + this.keystoreLoc;
    }

    public String getKeystoreLoc() {
        return this.keystoreLoc;
    }

    public boolean isServerAlive() {
        boolean isServerAlive = false;
        SSLSocket socket = null;
        if (this.factory == null) {
            this.initSocketFactory();
        }
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(1000L);
                System.out.println("Testing Connection:" + this.host + ":" + this.port);
                socket = (SSLSocket)this.factory.createSocket(this.host, this.port);
                socket.setEnabledCipherSuites(this.factory.getDefaultCipherSuites());
                if (!socket.isBound()) continue;
                System.out.println("connect isBound");
                isServerAlive = true;
                socket.close();
                break;
            }
            catch (ConnectException ex) {
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return isServerAlive;
    }

    public void testCiphersuites() {
        SSLSocket socket = null;
        int i = 0;
        if (this.factory == null) {
            this.initSocketFactory();
        }
        if (!this.isServerAlive()) {
            System.out.println("Unable to connect to " + this.host + ":" + this.port + " exiting.");
            System.exit(1);
        }
        Iterator iter = this.ciphersToTest.iterator();
        while (iter.hasNext()) {
            String cs = (String)iter.next();
            String[] ciphers = new String[]{cs};
            try {
                socket = (SSLSocket)this.factory.createSocket(this.host, this.port);
                socket.setEnabledCipherSuites(ciphers);
                this.testSSLSocket(socket, cs, i++);
            }
            catch (Exception ex) {
                System.out.println("failed ciphersuite" + ciphers[0]);
                this.f_ciphers.add(ciphers[0]);
            }
        }
    }

    public void configureCipherSuites(String server, String CipherSuite) {
        boolean testCipher = true;
        if (this.factory == null) {
            this.initSocketFactory();
        }
        String[] ciphers = this.factory.getSupportedCipherSuites();
        for (int i = 0; i < ciphers.length; ++i) {
            String ciphersuite = ciphers[i];
            testCipher = true;
            if (this.bVerbose) {
                System.out.print(ciphersuite);
            }
            if (server.equalsIgnoreCase("JSS") && (ciphersuite.indexOf("_DHE_") != -1 || ciphersuite.indexOf("_DES40_") != -1 || ciphersuite.indexOf("_anon_") != -1 || ciphersuite.indexOf("_KRB5_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                testCipher = false;
            }
            if (server.equalsIgnoreCase("JSSE")) {
                // empty if block
            }
            if (!testCipher) continue;
            this.ciphersToTest.add(ciphers[i]);
            if (!this.bVerbose) continue;
            System.out.print(" - Testing");
        }
        if (this.bVerbose) {
            System.out.print("\n");
        }
        if (this.bVerbose) {
            System.out.println("\nTesting " + this.ciphersToTest.size() + " ciphersuites.");
        }
    }

    private void initSocketFactory() {
        SSLContext ctx = null;
        KeyManagerFactory kmf = null;
        Object tmf = null;
        KeyStore ks = null;
        Object ksTrust = null;
        String provider = "SunJCE";
        char[] passphrase = "m1oZilla".toCharArray();
        try {
            String javaVendor = System.getProperty("java.vendor");
            if (javaVendor.equals("IBM Corporation")) {
                System.setProperty("java.protocol.handler.pkgs", "com.ibm.net.ssl.www.protocol.Handler");
                Security.addProvider((Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance());
                provider = "IBMJCE";
            } else {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((Provider)Class.forName("com.sun.crypto.provider.SunJCE").newInstance());
            }
            String certificate = new String("SunX509");
            ks = KeyStore.getInstance("PKCS12");
            if (javaVendor.equals("IBM Corporation")) {
                certificate = new String("IbmX509");
                ks = KeyStore.getInstance("PKCS12", provider);
            }
            kmf = KeyManagerFactory.getInstance(certificate);
            ks.load(new FileInputStream(this.getKeystoreLoc()), passphrase);
            kmf.init(ks, passphrase);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public boolean checkClientTrusted(X509Certificate[] chain) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] chain) {
                    return true;
                }

                public boolean isClientTrusted(X509Certificate[] chain) {
                    return true;
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            }};
            ctx = SSLContext.getInstance(this.sslRevision);
            ctx.init(kmf.getKeyManagers(), trustAllCerts, null);
            this.factory = ctx.getSocketFactory();
            String[] JSSE_ciphers = this.factory.getSupportedCipherSuites();
        }
        catch (KeyStoreException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendServerShutdownMsg() {
        try {
            SSLSocket socket = null;
            if (this.factory == null) {
                this.initSocketFactory();
            }
            socket = (SSLSocket)this.factory.createSocket(this.host, this.port);
            socket.setEnabledCipherSuites(this.factory.getDefaultCipherSuites());
            if (this.bVerbose) {
                System.out.println("Sending shutdown message to server.");
            }
            socket.startHandshake();
            OutputStream os = socket.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
            out.println("shutdown");
            out.flush();
            out.close();
            socket.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void testSSLSocket(SSLSocket socket, String ciphersuite, int socketID) {
        try {
            socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                public void handshakeCompleted(HandshakeCompletedEvent event) {
                    JSSE_SSLClient.this.h_ciphers.add(event.getCipherSuite());
                    System.out.println(event.getCipherSuite());
                }
            });
        }
        catch (Exception handshakeEx) {
            System.out.println(handshakeEx.getMessage());
            handshakeEx.printStackTrace();
            System.exit(1);
        }
        try {
            socket.setSoTimeout(10000);
            socket.startHandshake();
            String outputLine = null;
            String inputLine = null;
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            BufferedReader bir = new BufferedReader(new InputStreamReader(is));
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
            outputLine = ciphersuite + ":" + socketID + "\n";
            if (this.bVerbose) {
                System.out.println("Sending: " + outputLine);
            }
            out.print(outputLine);
            out.flush();
            inputLine = bir.readLine();
            if (this.bVerbose) {
                System.out.println("Received: " + inputLine + " on Client-" + socketID);
            }
            bir.close();
            out.close();
        }
        catch (SSLHandshakeException ex) {
            this.f_ciphers.add(ciphersuite);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        try {
            socket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void outputCipherResults() {
        Iterator iter;
        String banner = new String("\n----------------------------------------------------------\n");
        System.out.println(banner);
        System.out.println("JSSE has " + this.factory.getSupportedCipherSuites().length + " ciphersuites and " + this.ciphersToTest.size() + " were configured and tested.");
        if (this.ciphersToTest.size() == this.h_ciphers.size()) {
            System.out.println("All " + this.ciphersToTest.size() + " configured ciphersuites tested Successfully!\n");
        }
        if (!this.h_ciphers.isEmpty()) {
            if (!this.f_ciphers.isEmpty()) {
                System.out.println(banner);
                System.out.println(this.h_ciphers.size() + " ciphersuites successfully connected to the " + "server\n");
            }
            iter = this.h_ciphers.iterator();
            while (iter.hasNext()) {
                System.out.println((String)iter.next());
            }
        }
        if (this.bFipsMode) {
            System.out.println("Note: ciphersuites that have the prefix \"SSL\" or \"SSL3\" were used in TLS mode.");
        }
        if (this.ciphersToTest.size() != this.h_ciphers.size() + this.f_ciphers.size()) {
            System.out.println("ERROR: did not test all expected ciphersuites");
        }
        if (!this.f_ciphers.isEmpty()) {
            System.out.println(banner);
            System.out.println(this.f_ciphers.size() + " ciphersuites that did not connect to the " + "server\n\n");
            iter = this.f_ciphers.iterator();
            while (iter.hasNext()) {
                System.out.println((String)iter.next());
            }
            System.out.println("we should have no failed ciphersuites!");
            System.exit(1);
        }
        System.out.println(banner);
    }

    public static void main(String[] args) {
        String testCipher = null;
        String testHost = "localhost";
        String keystoreLocation = "rsa.pfx";
        int testPort = 29750;
        String serverType = "JSSE";
        String usage = "java org.mozilla.jss.tests.JSSE_SSLClient\n<keystore location> <test port> <test host> <server type> <test cipher>";
        try {
            if (args[0].toLowerCase().equals("-h") || args.length < 1) {
                System.out.println(usage);
                System.exit(1);
            }
            if (args.length >= 1) {
                keystoreLocation = args[0];
            }
            if (args.length >= 2) {
                testPort = new Integer(args[1]);
                System.out.println("using port: " + testPort);
            }
            if (args.length >= 3) {
                testHost = args[2];
            }
            if (args.length == 4) {
                serverType = args[3];
            }
            if (args.length == 5) {
                testCipher = args[4];
            }
        }
        catch (Exception e) {
            System.out.println(usage);
            System.exit(1);
        }
        JSSE_SSLClient sslSock = new JSSE_SSLClient();
        sslSock.setHost(testHost);
        sslSock.setPort(testPort);
        sslSock.setKeystoreLoc(keystoreLocation);
        sslSock.setCipherSuite(testCipher);
        sslSock.configureCipherSuites(serverType, testCipher);
        try {
            sslSock.testCiphersuites();
        }
        catch (Exception e) {
            System.out.println("Exception caught testing ciphersuites\n" + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        sslSock.sendServerShutdownMsg();
        sslSock.outputCipherResults();
        System.exit(0);
    }
}

