/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSSE_SSLServer {
    private int DefaultServerPort;
    private int port;
    private String type;
    private String configDir;
    private boolean bClientAuth;
    private boolean bVerbose;
    private Vector supportedCiphers;
    private CryptoManager manager;
    private String provider;

    public JSSE_SSLServer() throws IOException {
        this.port = this.DefaultServerPort = 29753;
        this.type = "SSLv3";
        this.configDir = "";
        this.bClientAuth = false;
        this.bVerbose = false;
        this.supportedCiphers = new Vector();
        this.provider = "SunJCE";
    }

    public void setProvider(String p) {
        this.provider = p;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setKeystore(String fconfigDir) {
        this.configDir = fconfigDir;
    }

    public String getKeystore() {
        return this.configDir;
    }

    public static void main(String[] args) {
        try {
            new JSSE_SSLServer().startSSLServer(args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startSSLServer(String[] args) throws Exception {
        String keystore;
        String configDir = "";
        String pwFile = "";
        String nssConfig = "";
        JSSE_SSLServer sslServer = new JSSE_SSLServer();
        if (args.length <= 1) {
            System.out.println("USAGE: java JSSE_SSLServer [port] [TLS | SSLv3][ClientAuth = true | false][config directory] [keystore filename][NSS DB passwordFile][JCE || Mozilla-JSS || Sunpkcs11]");
            System.out.println("\nIf the second argument is TLS, it will start as a\nTLS server, otherwise, it will be started in SSLv3 mode.\nIf the third argument is true,it will require\nclient authentication as well.");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            System.out.println(i + " = " + args[i]);
        }
        if (args.length >= 1) {
            this.port = Integer.parseInt(args[0]);
        }
        if (args.length >= 2) {
            this.type = args[1];
        }
        if (args.length >= 3 && args[2].equals("true")) {
            this.bClientAuth = true;
        }
        if (args.length >= 4 && args.length >= 5 && (keystore = (configDir = args[3]) + "/" + args[4]) != null) {
            sslServer.setKeystore(keystore);
        }
        if (args.length >= 7 && args.length >= 8) {
            if (args[5].equalsIgnoreCase("Mozilla-JSS")) {
                if (args.length >= 8) {
                    pwFile = args[7];
                }
                System.out.println("Initializing " + args[5]);
                CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(configDir);
                vals.removeSunProvider = false;
                CryptoManager.initialize(vals);
                this.manager = CryptoManager.getInstance();
                this.manager.setPasswordCallback(new FilePasswordCallback(pwFile));
            } else if (args[5].equalsIgnoreCase("Sunpkcs11")) {
                System.out.println("Sunpkcs11 requires JDK 1.5at this time JSS need to build with JDK 1.4.2");
            }
        }
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            System.out.println("Provider " + i + ": " + providers[i].getName());
        }
        try {
            System.out.println("creating SSLSockets:");
            SSLServerSocketFactory ssf = sslServer.getServerSocketFactory(this.type);
            if (ssf != null) {
                SSLServerSocket ss = (SSLServerSocket)ssf.createServerSocket(this.port);
                ss.setSoTimeout(300000);
                System.out.println("Enable ciphers.");
                ss.setEnabledCipherSuites(ss.getSupportedCipherSuites());
                System.out.println("Create JSSE SSLServer");
                ss.setNeedClientAuth(this.bClientAuth);
                JSSE_SSLServer JSSEServ = new JSSE_SSLServer();
                int socketCntr = 0;
                try {
                    while (true) {
                        Socket socket = ss.accept();
                        socket.setSoTimeout(300000);
                        readWriteThread rwThread = new readWriteThread(socket, ++socketCntr);
                        rwThread.start();
                    }
                }
                catch (IOException ex) {
                    System.out.println("Exception caught in SSLServerSocket.accept():" + ex.getMessage());
                    try {
                        ss.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                if (System.getProperty("java.vendor").equals("IBM Corporation")) {
                    System.out.println("Using IBM JDK: Cannot load keystore due to strong security encryption settings\nwith limited Jurisdiction policy files :\n http://www-1.ibm.com/support/docview.wss?uid=swg21169931");
                    System.exit(0);
                }
                System.out.println("unable to initialize JSSE_SocketFactory exiting!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to start JSSE_SSLServer: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Main JSSE_SSLServer exiting.");
        System.exit(0);
    }

    SSLServerSocketFactory getServerSocketFactory(String type) {
        SSLContext ctx = null;
        KeyManagerFactory kmf = null;
        KeyStore ks = null;
        char[] passphrase = "m1oZilla".toCharArray();
        SSLServerSocketFactory ssf = null;
        System.setProperty("javax.net.ssl.trustStore", System.getProperty("java.home") + "/jre/lib/security/cacerts");
        String certificate = "SunX509";
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.equals("IBM Corporation")) {
            certificate = "IbmX509";
        }
        System.out.println("keystore loc: " + this.getKeystore());
        if (!type.equals("TLS") && !type.equals("SSLv3")) {
            System.out.println("type must equal 'TLS' or 'SSLv3'\n");
            System.exit(1);
        }
        try {
            ctx = SSLContext.getInstance(type);
            kmf = KeyManagerFactory.getInstance(certificate);
            ks = KeyStore.getInstance("PKCS12");
            ks.load(new FileInputStream(this.getKeystore()), passphrase);
            kmf.init(ks, passphrase);
            ctx.init(kmf.getKeyManagers(), null, null);
            ssf = ctx.getServerSocketFactory();
            return ssf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ssf;
        }
    }

    private class readWriteThread
    extends Thread {
        private Socket socket = null;
        private int socketCntr = 0;

        public readWriteThread(Socket sock, int cntr) {
            this.socket = sock;
            this.socketCntr = cntr;
        }

        public void run() {
            try {
                OutputStream os;
                InputStream is;
                block11: {
                    String inputLine = null;
                    String outputLine = null;
                    is = this.socket.getInputStream();
                    os = this.socket.getOutputStream();
                    BufferedReader bir = new BufferedReader(new InputStreamReader(is));
                    PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                    try {
                        while ((inputLine = bir.readLine()) != null) {
                            if (inputLine.equalsIgnoreCase("shutdown")) {
                                if (JSSE_SSLServer.this.bVerbose) {
                                    System.out.println("Client told  JSSE_SSLServer to Shutdown!");
                                }
                                is.close();
                                os.close();
                                this.socket.close();
                                System.exit(0);
                            }
                            outputLine = "ServerSSLSocket- " + this.socketCntr;
                            if (JSSE_SSLServer.this.bVerbose) {
                                System.out.println("ServerSSLSocket-" + this.socketCntr + ": Received " + inputLine);
                                System.out.println("Sending" + outputLine);
                            }
                            out.println(outputLine);
                            out.flush();
                        }
                        if (JSSE_SSLServer.this.bVerbose) {
                            System.out.println("ServerSSLSocket-" + this.socketCntr + " read null aborting connection.");
                        }
                    }
                    catch (SocketTimeoutException ste) {
                        System.out.println("ServerSSLSocket-" + this.socketCntr + " timed out: " + ste.toString());
                    }
                    catch (IOException ex) {
                        if (!JSSE_SSLServer.this.bVerbose) break block11;
                        ex.printStackTrace();
                    }
                }
                is.close();
                os.close();
                this.socket.close();
                if (JSSE_SSLServer.this.bVerbose) {
                    System.out.println("ServerSSLSocket " + this.socketCntr + " has been Closed.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

