/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.FilePasswordCallback;

public class JSS_FileUploadServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String fServerCertNick = null;
    private String fServerHost = "localhost";
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private boolean TestInetAddress = false;
    private boolean success = true;
    public static int port = 29755;
    public static String usage = "\nUSAGE:\njava JSS_FileUploadServer [certdb path] [password file]\n[server_host_name] [cert nickname][testInetAddress: true|false]";

    public static void main(String[] args) throws Exception {
        try {
            new JSS_FileUploadServer().doIt(args);
        }
        catch (Exception e) {
            System.out.println("Exception caught: " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void doIt(String[] args) throws Exception {
        if (args.length < 1 || args[0].toLowerCase().indexOf("-h") != -1) {
            System.out.println(usage);
            System.exit(1);
        }
        int socketCntr = 0;
        try {
            if (args[0].length() > 0 && !args[0].equals(".")) {
                this.fCertDbPath = args[0];
            }
            if (args[1].length() > 0 && !args[1].equals("passwords")) {
                this.fPasswordFile = args[1];
            }
            if (args[2].length() > 0 && !args[2].equals("localhost")) {
                this.fServerHost = args[2];
            }
            if (args[3].length() > 0) {
                this.fServerCertNick = args[3];
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        CryptoManager.initialize(this.fCertDbPath);
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken tok = cm.getInternalKeyStorageToken();
        FilePasswordCallback cb = new FilePasswordCallback(this.fPasswordFile);
        tok.login(cb);
        if (args[4].equalsIgnoreCase("true")) {
            this.TestInetAddress = true;
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        SSLSocket.enableSSL2Default(false);
        serverSock = this.TestInetAddress ? new SSLServerSocket(port, 5, InetAddress.getByName(this.fServerHost), null, true) : new SSLServerSocket(port, 5, null, null, true);
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname(this.fServerCertNick);
        System.out.println("Server ready to accept connections");
        while (true) {
            sock = (SSLSocket)serverSock.accept();
            sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
            readWriteThread rwThread = new readWriteThread(sock, ++socketCntr);
            rwThread.start();
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_FileUploadServer boss;

        public HandshakeListener(String who, JSS_FileUploadServer boss) {
            this.who = who;
            this.boss = boss;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            try {
                String mesg = this.who + " got a completed handshake ";
                SSLSecurityStatus status = event.getStatus();
                mesg = status.isSecurityOn() ? mesg + "(security is ON)" : mesg + "(security is OFF)";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.boss.setFailure();
            }
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket socket = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sock, int cntr) {
            this.socket = sock;
            this.socketCntr = cntr;
        }

        public void run() {
            try {
                Object socketData = null;
                Object cbuf = null;
                boolean readLength = false;
                String readString = null;
                InputStream is = this.socket.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(is));
                long timeInMs = new Date().getTime();
                while ((readString = in.readLine()) != null) {
                    long now = new Date().getTime();
                    System.out.print("Read " + readString.getBytes().length + "bytes in " + (now - timeInMs) + "\n");
                    timeInMs = now;
                }
            }
            catch (Exception e) {
                System.out.println("Exception caught in readWriteThread.run()\n");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

