/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.ConstantsBase;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.tests.TestCertificateApprovalCallback;
import org.mozilla.jss.util.Debug;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.PasswordCallback;

public class JSS_SelfServClient
implements ConstantsBase,
Constants {
    private String clientCertNick = "default";
    private String serverHost = "localhost";
    private String ciphersuiteTested = null;
    private boolean TestCertCallBack = false;
    private boolean success = true;
    private int fCipher = -1;
    private int aWorkingCipher = 0;
    private boolean bTestCiphers = true;
    private String CipherName = null;
    private int port = 29754;
    private String EOF = "test";
    private boolean handshakeCompleted = false;
    private boolean bVerbose = false;
    private boolean bFipsMode = false;
    private boolean bBypassPKCS11 = false;
    private ArrayList ciphersToTest = new ArrayList();
    private CryptoManager cm = null;
    private CryptoToken tok = null;
    private PasswordCallback cb = null;
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private ArrayList sockList = new ArrayList();
    private ArrayList h_ciphers = new ArrayList();
    private ArrayList f_ciphers = new ArrayList();
    private int sockID = 0;
    private static boolean bJSS = false;
    private ThreadGroup socketThreads = new ThreadGroup("SSLSockets");

    public void setTestCiphers(boolean t) {
        this.bTestCiphers = t;
    }

    public boolean getTestCiphers() {
        return this.bTestCiphers;
    }

    public void setVerbose(boolean v) {
        this.bVerbose = v;
    }

    public void setBypassPKCS11(boolean f) {
        this.bBypassPKCS11 = f;
    }

    public boolean getBypassPKCS11() {
        return this.bBypassPKCS11;
    }

    public boolean testJSSCiphersMatchNSS() {
        this.initJSS();
        boolean cipherSuites = true;
        int[] ciphers = SSLSocket.getImplementedCipherSuites();
        for (int i = 0; i < ciphers.length; ++i) {
            if (Constants.cipher.cipherToString(ciphers[i]) != null) continue;
            cipherSuites = false;
            System.out.println("JSS does not support ciphersuite: " + Integer.toHexString(ciphers[i]));
        }
        if (!cipherSuites) {
            System.out.println("ERROR: NSS has implemented ciphersuites that JSS does not support!\n");
            System.out.println("see http://mxr.mozilla.org/security/source/security/nss/lib/ssl/sslproto.h");
            System.out.println("Update org/mozilla/jss/ssl/SSLSocket.java");
            System.out.println("Update org/mozilla/jss/tests/Constants.java");
            System.out.println("NSS implemented Ciphersuites missing from JSS");
        }
        return cipherSuites;
    }

    public void configureDefaultSSLOptions() {
        this.initJSS();
        try {
            SSLSocket.enableSSL2Default(false);
            if (this.bFipsMode) {
                SSLSocket.enableSSL3Default(false);
            }
            if (this.bBypassPKCS11 && !this.bFipsMode) {
                SSLSocket.bypassPKCS11Default(true);
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void configureCipherSuites(String server) {
        int[] ciphers = SSLSocket.getImplementedCipherSuites();
        for (int i = 0; i < ciphers.length; ++i) {
            String ciphersuite = Constants.cipher.cipherToString(ciphers[i]);
            boolean testCipher = true;
            if (this.bVerbose) {
                System.out.print(ciphersuite);
            }
            if (server.equalsIgnoreCase("JSS") && (ciphersuite.indexOf("_DHE_") != -1 || ciphersuite.indexOf("SSL2") != -1 || ciphersuite.indexOf("RSA") != -1 && ciphersuite.indexOf("_ECDH_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                testCipher = false;
            }
            if (server.equalsIgnoreCase("JSSE") && (ciphersuite.indexOf("SSL2_") != -1 || ciphersuite.indexOf("_ECDHE_") != -1 || ciphersuite.indexOf("_ECDH_") != -1 || ciphersuite.indexOf("_CAMELLIA_") != -1 || ciphersuite.indexOf("_SEED_") != -1 || ciphersuite.indexOf("_DHE_DSS_") != -1 || ciphersuite.indexOf("_EXPORT1024_") != -1 || ciphersuite.indexOf("_RSA_FIPS_") != -1 || ciphersuite.indexOf("EXPORT_WITH_RC2") != -1 || ciphersuite.indexOf("_ECDSA_") != -1 || ciphersuite.indexOf("_256_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                testCipher = false;
            }
            if (server.equalsIgnoreCase("Mozilla-JSS") && (ciphersuite.indexOf("SSL2_") != -1 || ciphersuite.indexOf("_ECDHE_") != -1 || ciphersuite.indexOf("_ECDH_") != -1 || ciphersuite.indexOf("_CAMELLIA_") != -1 || ciphersuite.indexOf("_SEED_") != -1 || ciphersuite.indexOf("_DHE_DSS_") != -1 || ciphersuite.indexOf("_EXPORT1024_") != -1 || ciphersuite.indexOf("_RSA_FIPS_") != -1 || ciphersuite.indexOf("EXPORT_WITH_RC2") != -1 || ciphersuite.indexOf("_ECDSA_") != -1 || ciphersuite.indexOf("SSL3_DHE_RSA_WITH_3DES_EDE_CBC_SHA") != -1 || ciphersuite.indexOf("SSL3_RSA_WITH_3DES_EDE_CBC_SHA") != -1 || ciphersuite.indexOf("SSL3_DHE_RSA_WITH_DES_CBC_SHA") != -1 || ciphersuite.indexOf("SSL3_RSA_WITH_DES_CBC_SHA") != -1 || ciphersuite.indexOf("SSL3_RSA_EXPORT_WITH_RC4_40_MD5") != -1 || ciphersuite.indexOf("_256_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                testCipher = false;
            }
            if (!testCipher) continue;
            if (this.bFipsMode) {
                try {
                    if (SSLSocket.isFipsCipherSuite(ciphers[i])) {
                        this.ciphersToTest.add(new Integer(ciphers[i]));
                        if (!this.bVerbose) continue;
                        System.out.print(" - FIPS Testing");
                        continue;
                    }
                    if (!this.bVerbose) continue;
                    System.out.print(" -");
                }
                catch (SocketException ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            this.ciphersToTest.add(new Integer(ciphers[i]));
            if (!this.bVerbose) continue;
            System.out.print(" - Testing");
        }
        if (this.bVerbose) {
            System.out.print("\n");
        }
        if (this.bVerbose) {
            System.out.println("\nTesting " + this.ciphersToTest.size() + " ciphersuites.");
        }
    }

    public void testCiphersuites(int numOfThreads) {
        Iterator iter = this.ciphersToTest.iterator();
        this.setTestCiphers(true);
        while (iter.hasNext()) {
            this.setCipher((Integer)iter.next());
            try {
                this.createSSLConnections(numOfThreads);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void setCipher(int aCipher) {
        this.initJSS();
        int[] ciphers = SSLSocket.getImplementedCipherSuites();
        this.ciphersuiteTested = Constants.cipher.cipherToString(aCipher);
        if (this.bVerbose || !this.bTestCiphers) {
            System.out.println("Testing " + Integer.toHexString(aCipher) + " " + this.ciphersuiteTested);
        }
        if (this.ciphersuiteTested != null) {
            this.fCipher = aCipher;
        } else {
            System.out.print("ciphersuite not supported");
            System.exit(1);
        }
        try {
            if (this.cm.FIPSEnabled() && !SSLSocket.isFipsCipherSuite(aCipher)) {
                System.out.println("You are trying to test a non FIPS ciphersuite when FIPS is enabled!");
                System.exit(1);
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < ciphers.length; ++i) {
            try {
                if (!SSLSocket.getCipherPreferenceDefault(ciphers[i])) continue;
                SSLSocket.setCipherPreferenceDefault(ciphers[i], false);
                continue;
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setHostName(String aHostName) {
        this.serverHost = aHostName;
    }

    public void setPort(int aPort) {
        this.port = aPort;
    }

    public void setPasswordFile(String aPasswordFile) {
        this.fPasswordFile = aPasswordFile;
    }

    public void setCertDbPath(String aCertDbPath) {
        this.fCertDbPath = aCertDbPath;
    }

    public void setTestCertCallback(boolean aTestCertCallback) {
        this.TestCertCallBack = aTestCertCallback;
    }

    public void setClientCertNick(String aClientCertNick) {
        this.clientCertNick = aClientCertNick;
        try {
            X509Certificate[] certs = this.cm.findCertsByNickname(this.clientCertNick);
            if (certs.length == 0) {
                System.out.println("unable to find cert nickname: " + this.clientCertNick);
                System.exit(1);
            }
        }
        catch (TokenException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public int getSockTotal() {
        return this.sockID;
    }

    private void initJSS() {
        if (bJSS) {
            return;
        }
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(this.fCertDbPath);
            CryptoManager.initialize(vals);
            this.cm = CryptoManager.getInstance();
            if (this.cm.FIPSEnabled()) {
                System.out.println("The database is in FIPSMODE");
                this.bFipsMode = true;
            }
            this.tok = this.cm.getInternalKeyStorageToken();
            this.cb = new FilePasswordCallback(this.fPasswordFile);
            this.tok.login(this.cb);
            bJSS = true;
            if (this.bVerbose) {
                Debug.setLevel(10);
            }
        }
        catch (KeyDatabaseException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (CertDatabaseException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (CryptoManager.NotInitializedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (AlreadyInitializedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (GeneralSecurityException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (TokenException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IncorrectPasswordException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public boolean isServerAlive() {
        boolean isServerAlive = false;
        try {
            SSLSocket s = null;
            if (this.bVerbose) {
                System.out.println("Confirming Server is alive ");
            }
            this.setCipher(47);
            System.out.println("Testing Connection:" + this.serverHost + ":" + this.port);
            for (int i = 0; i < 20 && (s = this.createSSLSocket()) == null; ++i) {
                Thread.sleep(1000L);
            }
            if (s != null) {
                s.close();
                isServerAlive = true;
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return isServerAlive;
    }

    public void sendServerShutdownMsg() {
        try {
            SSLSocket s = null;
            if (this.bVerbose) {
                System.out.println("Sending shutdown message to server.");
            }
            if (this.aWorkingCipher == 0) {
                System.out.println("no ciphersuite was able to connect to the server!");
                System.exit(1);
            }
            this.setCipher(this.aWorkingCipher);
            s = this.createSSLSocket();
            if (s == null) {
                throw new IOException("Unable to connect to server");
            }
            OutputStream os = s.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
            out.println("shutdown");
            out.flush();
            out.close();
            s.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void closeAllSockets() {
        try {
            long start = System.currentTimeMillis();
            Iterator sIter = this.sockList.iterator();
            while (sIter.hasNext()) {
                SSLSocket s = (SSLSocket)sIter.next();
                s.close();
            }
            System.out.println("Waiting till all threads are dead");
            int i = 0;
            while (this.socketThreads.activeCount() > 0) {
                Thread.sleep(10L);
                System.out.println("ActiveCount" + this.socketThreads.activeCount());
                if (i == 100) {
                    System.out.println("It is taking too long for the threads to die. Exiting the program");
                    System.out.println("Time taken: " + (System.currentTimeMillis() - start) + " Milliseconds");
                    return;
                }
                ++i;
            }
            System.out.println("All threads are dead. Time taken: " + (System.currentTimeMillis() - start) + " Milliseconds.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private SSLSocket createSSLSocket() {
        SSLSocket sock = null;
        try {
            if (this.bVerbose) {
                System.out.println("client about to connect...");
            }
            String hostAddr = InetAddress.getByName(this.serverHost).getHostAddress();
            if (this.bVerbose) {
                System.out.println("the host " + this.serverHost + " and the address " + hostAddr);
            }
            if (this.TestCertCallBack) {
                if (this.bVerbose) {
                    System.out.println("calling approvalCallBack");
                }
                sock = new SSLSocket(InetAddress.getByName(hostAddr), this.port, null, 0, (SSLCertificateApprovalCallback)new TestCertificateApprovalCallback(), null);
            } else {
                if (this.bVerbose) {
                    System.out.println("NOT calling approvalCallBack");
                }
                sock = new SSLSocket(InetAddress.getByName(hostAddr), this.port);
            }
            if (this.clientCertNick.equalsIgnoreCase("default")) {
                sock.setClientCertNickname("Client_RSA");
                sock.setClientCertNickname("Client_ECDSA");
                sock.setClientCertNickname("Client_DSS");
            } else {
                sock.setClientCertNickname(this.clientCertNick);
                if (this.bVerbose) {
                    System.out.println("Client specified cert by nickname");
                }
            }
            if (sock.getCipherPreference(this.fCipher)) {
                System.out.println("Ciphersuite should have been disabled?");
                System.exit(1);
            } else {
                sock.setCipherPreference(this.fCipher, true);
            }
            sock.addHandshakeCompletedListener(new HandshakeListener("client", this));
            sock.forceHandshake();
            sock.setSoTimeout(10000);
            this.sockList.add(sock);
            ++this.sockID;
            this.aWorkingCipher = this.fCipher;
            if (this.bVerbose) {
                System.out.println("client connected");
            }
        }
        catch (SocketException ex) {
            if (this.bTestCiphers) {
                sock = null;
            } else {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return sock;
    }

    public void outputCipherResults() {
        Iterator iter;
        String banner = new String("\n-------------------------------------------------------\n");
        System.out.println(banner);
        System.out.println("JSS has " + SSLSocket.getImplementedCipherSuites().length + " ciphersuites and " + this.ciphersToTest.size() + " were configured and tested.");
        if (this.ciphersToTest.size() == this.h_ciphers.size()) {
            System.out.println("All " + this.ciphersToTest.size() + " configured ciphersuites tested Successfully!\n");
        }
        if (!this.h_ciphers.isEmpty()) {
            if (!this.f_ciphers.isEmpty()) {
                System.out.println(banner);
                System.out.println(this.h_ciphers.size() + " ciphersuites successfully connected to the " + "server\n");
            }
            iter = this.h_ciphers.iterator();
            while (iter.hasNext()) {
                System.out.println((String)iter.next());
            }
        }
        if (this.bFipsMode) {
            System.out.println("Note: ciphersuites that have the prefix \"SSL\" or \"SSL3\" were used in TLS mode.");
        }
        if (this.ciphersToTest.size() != this.h_ciphers.size() + this.f_ciphers.size()) {
            System.out.println("ERROR: did not test all expected ciphersuites");
        }
        if (!this.f_ciphers.isEmpty()) {
            System.out.println(banner);
            System.out.println(this.f_ciphers.size() + " ciphersuites that did not connect to the " + "server\n\n");
            iter = this.f_ciphers.iterator();
            while (iter.hasNext()) {
                System.out.println((String)iter.next());
            }
            System.out.println("we should have no failed ciphersuites!");
            System.exit(1);
        }
        System.out.println(banner);
    }

    public void createSSLConnections(int numToCreate) throws Exception {
        SSLSocket sock = null;
        this.initJSS();
        for (int i = 1; i <= numToCreate; ++i) {
            sock = this.createSSLSocket();
            if (sock != null) {
                String threadName = new String(this.sockID + "-" + i);
                readWriteThread rwThread = new readWriteThread(this.socketThreads, threadName, this.ciphersuiteTested, sock);
                rwThread.start();
                if (i != 1) continue;
                this.h_ciphers.add(this.ciphersuiteTested);
                continue;
            }
            if (!this.bTestCiphers) break;
            this.f_ciphers.add(this.ciphersuiteTested);
            break;
        }
        if (this.bVerbose) {
            System.out.println("Active thread count: " + this.socketThreads.activeCount());
            System.out.println("Total threads created: " + this.getSockTotal());
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static void main(String[] args) {
        String certnick = "default";
        int testCipher = -1;
        String testhost = "localhost";
        int testport = 29754;
        int numOfThreads = 10;
        String certDbPath = null;
        String passwdFile = null;
        boolean bBypassPKCS11 = false;
        boolean bVerbose = false;
        String server = "JSS";
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        String usage = "\nUSAGE:\njava org.mozilla.jss.tests.JSS_SelfServClient [# sockets] [JSS cipher hex code \"0xC013\" value or -1] \n\nOptional:\n[certdb path] [password file] [server host] [server port][bypass] [verbose] [server = JSS or JSSE] [ClientCert]";
        try {
            if (args.length <= 0 || args[0].toLowerCase().equals("-h")) {
                System.out.println(usage);
                System.exit(1);
            } else {
                numOfThreads = new Integer(args[0]);
                System.out.println("Number of Threads to create: " + numOfThreads);
            }
            if (args.length >= 2) {
                testCipher = args[1].startsWith("0x") || args[1].startsWith("0X") ? Integer.decode(args[1]).intValue() : new Integer(args[1]).intValue();
            }
            if (args.length >= 3) {
                certDbPath = args[2];
            }
            if (args.length >= 4) {
                passwdFile = args[3];
            }
            if (args.length >= 5) {
                testhost = args[4];
            }
            if (args.length >= 6) {
                testport = new Integer(args[5]);
            }
            if (args.length >= 7 && args[6].equalsIgnoreCase("bypass")) {
                bBypassPKCS11 = true;
            }
            if (args.length >= 8 && args[7].equalsIgnoreCase("verbose")) {
                System.out.println("verbose mode enabled.");
                bVerbose = true;
            }
            if (args.length >= 9) {
                server = args[8].toUpperCase();
            }
            if (args.length >= 10) {
                certnick = args[9];
                System.out.println("certnickname: " + certnick);
            }
        }
        catch (Exception e) {
            System.out.println("Unknown exception : " + e.getMessage());
            System.exit(1);
        }
        System.out.println("Client connecting to server: " + testhost + ":" + testport);
        JSS_SelfServClient jssTest = new JSS_SelfServClient();
        try {
            if (!testhost.equals("localhost")) {
                jssTest.setHostName(testhost);
            }
            if (testport != 29754) {
                jssTest.setPort(testport);
            }
            jssTest.setPasswordFile(passwdFile);
            jssTest.setCertDbPath(certDbPath);
            jssTest.setVerbose(bVerbose);
            jssTest.initJSS();
            if (!jssTest.testJSSCiphersMatchNSS()) {
                System.out.println("JSS needs to update the ciphersuites!");
                System.exit(1);
            }
            jssTest.setTestCertCallback(true);
            jssTest.setBypassPKCS11(bBypassPKCS11);
            jssTest.configureDefaultSSLOptions();
            if (certDbPath != null) {
                jssTest.setCertDbPath(certDbPath);
            }
            if (passwdFile != null) {
                jssTest.setPasswordFile(passwdFile);
            }
            if (!jssTest.isServerAlive()) {
                System.out.println("Server " + testhost + ":" + testport + " is not Alive.\nIf this test was ran by " + "all.pl look at the server invocation for failures " + "and check network issues.");
                System.exit(1);
            }
            if (testCipher != -1) {
                jssTest.setClientCertNick(certnick);
                jssTest.setTestCiphers(false);
                jssTest.setCipher(testCipher);
                jssTest.createSSLConnections(numOfThreads);
            } else {
                jssTest.configureCipherSuites(server);
                jssTest.testCiphersuites(numOfThreads);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        if (jssTest.getSockTotal() == 0) {
            System.out.println("No SSLSockets created check your configuration.");
            System.exit(1);
        }
        System.out.println(jssTest.getSockTotal() + " SSLSockets created.");
        System.out.println("Each created SSLSocket is reading/writing to the SSLServer.");
        if (jssTest.getTestCiphers()) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            jssTest.closeAllSockets();
            jssTest.sendServerShutdownMsg();
            jssTest.outputCipherResults();
            System.exit(0);
        }
        System.out.println("You can choose to exit the program enter:\n\t'A' to abort with out closing the sockets.\n\t'C' to close all client sockets (server will not quit)\n\tor any other letter to close all sockets and tell theserver to quit.");
        try {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            String p = stdin.readLine();
            if (p.equalsIgnoreCase("a")) {
                System.out.println("Aborting with out closing SSLSockets.");
            } else {
                jssTest.closeAllSockets();
                if (!p.equalsIgnoreCase("c")) {
                    jssTest.sendServerShutdownMsg();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SelfServClient boss;

        public HandshakeListener(String who, JSS_SelfServClient boss) {
            this.who = who;
            this.boss = boss;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            try {
                String mesg = this.who + " got a completed handshake ";
                SSLSecurityStatus status = event.getStatus();
                mesg = status.isSecurityOn() ? mesg + "(security is ON)" : mesg + "(security is OFF)";
                if (JSS_SelfServClient.this.bVerbose) {
                    System.out.println(mesg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            JSS_SelfServClient.this.setHandshakeCompleted();
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket clientSock = null;
        private String socketID = null;
        private String ciphersuite;

        public readWriteThread(ThreadGroup tgOb, String tName, String cs, SSLSocket sock) {
            super(tgOb, tName);
            if (JSS_SelfServClient.this.bVerbose) {
                System.out.println("New thread: " + this);
            }
            this.ciphersuite = cs;
            this.clientSock = sock;
            this.socketID = tName;
        }

        public void run() {
            try {
                String outputLine = null;
                String inputLine = null;
                InputStream is = this.clientSock.getInputStream();
                OutputStream os = this.clientSock.getOutputStream();
                BufferedReader bir = new BufferedReader(new InputStreamReader(is));
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                while (true) {
                    outputLine = this.ciphersuite + ":" + this.socketID + "\n";
                    if (JSS_SelfServClient.this.bVerbose) {
                        System.out.println("Sending: " + outputLine);
                    }
                    out.print(outputLine);
                    out.flush();
                    inputLine = bir.readLine();
                    if (JSS_SelfServClient.this.bVerbose) {
                        System.out.println("Received: " + inputLine + " on Client-" + this.socketID);
                    }
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (SocketTimeoutException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                if (!e.getMessage().equalsIgnoreCase("SocketException cannot read on socket") && !e.getMessage().equalsIgnoreCase("Socket has been closed, and cannot be reused.")) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

