/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Vector;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedListener;
import org.mozilla.jss.ssl.SSLSecurityStatus;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.tests.Constants;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.util.Debug;

public class JSS_SelfServServer {
    private static Vector jssSupportedCiphers = new Vector();
    private static SSLServerSocket serverSock = null;
    private static SSLSocket sock = null;
    private String fServerCertNick = null;
    private String fServerHost = "localhost";
    private String fPasswordFile = "passwords";
    private String fCertDbPath = ".";
    private boolean TestInetAddress = false;
    private boolean success = true;
    private boolean bVerbose = false;
    private boolean bBypass = false;
    public int port = 29754;
    public static String usage = "\nUSAGE:\njava JSS_SelfServServer [certdb path] [password file]\n[server_host_name] [testInetAddress: true|false]<port> <bypass> <verbose> <cert nickname> ";

    public static void main(String[] args) throws Exception {
        try {
            new JSS_SelfServServer().doIt(args);
        }
        catch (Exception e) {
            System.out.println("JSS_SelfServServer exiting with Exception " + e.getMessage());
            System.exit(1);
        }
        System.exit(0);
    }

    public void JSS_SelfServServer() {
    }

    public void doIt(String[] args) throws Exception {
        int i;
        int[] ciphers;
        if (args.length < 5 || args[0].toLowerCase().equals("-h")) {
            System.out.println(usage);
            System.exit(1);
        }
        try {
            if (!args[0].equals(".")) {
                this.fCertDbPath = args[0];
            }
            if (!args[1].equals("passwords")) {
                this.fPasswordFile = args[1];
            }
            if (!args[2].equals("localhost")) {
                this.fServerHost = args[2];
            }
            if (args[3].equalsIgnoreCase("true")) {
                this.TestInetAddress = true;
            }
            if (args.length >= 5) {
                this.port = new Integer(args[4]);
            }
            if (args.length >= 6 && args[5].equalsIgnoreCase("bypass")) {
                this.bBypass = true;
            }
            if (args.length >= 7 && args[6].equalsIgnoreCase("verbose")) {
                this.bVerbose = true;
            }
            if (args.length >= 8 && !args[7].equalsIgnoreCase("default")) {
                this.fServerCertNick = args[7];
            }
        }
        catch (Exception e) {
            System.out.println("Error parsing command line " + e.getMessage());
            System.out.println(usage);
            System.exit(1);
        }
        if (this.bVerbose) {
            System.out.println("initializing JSS");
        }
        CryptoManager.initialize(this.fCertDbPath);
        CryptoManager cm = CryptoManager.getInstance();
        CryptoToken tok = cm.getInternalKeyStorageToken();
        FilePasswordCallback cb = new FilePasswordCallback(this.fPasswordFile);
        tok.login(cb);
        if (this.bVerbose) {
            Debug.setLevel(10);
        }
        SSLServerSocket.configServerSessionIDCache(10, 100, 100, null);
        if (cm.FIPSEnabled()) {
            if (this.bBypass) {
                System.out.println("Bypass mode cannot be set in FIPS mode.");
                System.out.println(usage);
                System.exit(1);
            }
            SSLSocket.enableSSL2Default(false);
            SSLSocket.enableSSL3Default(false);
            ciphers = SSLSocket.getImplementedCipherSuites();
            for (i = 0; i < ciphers.length; ++i) {
                if (SSLSocket.isFipsCipherSuite(ciphers[i])) {
                    SSLSocket.setCipherPreferenceDefault(ciphers[i], true);
                    continue;
                }
                if (!SSLSocket.getCipherPreferenceDefault(ciphers[i])) continue;
                SSLSocket.setCipherPreferenceDefault(ciphers[i], false);
            }
        } else {
            ciphers = SSLSocket.getImplementedCipherSuites();
            for (i = 0; i < ciphers.length; ++i) {
                try {
                    SSLSocket.setCipherPreferenceDefault(ciphers[i], true);
                    if (!this.bVerbose) continue;
                    System.out.println(Constants.cipher.cipherToString(ciphers[i]) + " " + Integer.toHexString(ciphers[i]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
            SSLSocket.enableSSL2Default(false);
            SSLSocket.bypassPKCS11Default(this.bBypass);
        }
        if (this.bVerbose) {
            if (this.bBypass) {
                System.out.println("SSLSockets in Bypass Mode");
            } else {
                System.out.println("SSLSockets in Non Bypass Mode");
            }
        }
        if (this.bVerbose) {
            System.out.println("JSS_SelfServServ about .... to create socket");
        }
        if (this.TestInetAddress) {
            if (this.bVerbose) {
                System.out.println("JSS_SelfServServ HostName " + this.fServerHost + " the Inet Address " + InetAddress.getByName(this.fServerHost));
            }
            serverSock = new SSLServerSocket(this.port, 5, InetAddress.getByName(this.fServerHost), null, true);
        } else {
            if (this.bVerbose) {
                System.out.println("Inet set to Null");
            }
            serverSock = new SSLServerSocket(this.port, 5, null, null, true);
        }
        if (this.bVerbose) {
            System.out.println("JSS_SelfServServ created socket");
        }
        serverSock.setSoTimeout(600000);
        serverSock.requireClientAuth(21);
        serverSock.setServerCertNickname("Server_ECDSA");
        serverSock.setServerCertNickname("Server_RSA");
        serverSock.setServerCertNickname("Server_DSS");
        if (this.bVerbose) {
            System.out.println("JSS_SelfServServ specified cert by nickname");
        }
        System.out.println("JSS_SelfServServ " + this.fServerHost + " ready to accept connections on " + this.port);
        int socketCntr = 0;
        try {
            while (true) {
                sock = (SSLSocket)serverSock.accept();
                sock.addHandshakeCompletedListener(new HandshakeListener("server", this));
                ++socketCntr;
                sock.setSoTimeout(300000);
                if (this.bVerbose) {
                    System.out.println("Timeout value for SSL sockets: " + sock.getSoTimeout() + " milliseconds");
                }
                readWriteThread rwThread = new readWriteThread(sock, socketCntr);
                rwThread.start();
            }
        }
        catch (SocketTimeoutException ex) {
            if (socketCntr == 0) {
                System.out.println("JSS_SelfServServ No Client attempted to connect! If test ran from all.pl check the client execution for errors.");
            } else {
                System.out.println("JSS_SelfServServ there has been " + socketCntr + " client " + " connections but the server Accept has timed out!");
            }
            System.out.println("JSS_SelfServServ Timeout value: " + serverSock.getSoTimeout() + " milliseconds");
            ex.printStackTrace();
            System.out.println("JSS_SelfServServ exiting due to timeout.");
            System.exit(1);
        }
        catch (Exception ex) {
            System.out.println("JSS_SelfServServ Exception:");
            ex.printStackTrace();
            System.out.println("JSS_SelfServServ exiting.");
            System.exit(1);
        }
    }

    public synchronized void setFailure() {
        this.success = false;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public static class HandshakeListener
    implements SSLHandshakeCompletedListener {
        private String who;
        private JSS_SelfServServer boss;

        public HandshakeListener(String who, JSS_SelfServServer boss) {
            this.who = who;
            this.boss = boss;
        }

        public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
            try {
                String mesg = this.who + " got a completed handshake ";
                SSLSecurityStatus status = event.getStatus();
                mesg = status.isSecurityOn() ? mesg + "(security is ON)" : mesg + "(security is OFF)";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.boss.setFailure();
            }
        }
    }

    private class readWriteThread
    extends Thread {
        private SSLSocket socket = null;
        private int socketCntr = 0;

        public readWriteThread(SSLSocket sock, int cntr) {
            this.socket = sock;
            this.socketCntr = cntr;
        }

        public void run() {
            try {
                String inputLine = null;
                String outputLine = null;
                InputStream is = this.socket.getInputStream();
                OutputStream os = this.socket.getOutputStream();
                BufferedReader bir = new BufferedReader(new InputStreamReader(is));
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                try {
                    while ((inputLine = bir.readLine()) != null) {
                        if (inputLine.equalsIgnoreCase("shutdown")) {
                            if (JSS_SelfServServer.this.bVerbose) {
                                System.out.println("Client told  JSS_SelfServServer to Shutdown!");
                            }
                            is.close();
                            os.close();
                            this.socket.close();
                            System.exit(0);
                        }
                        outputLine = "ServerSSLSocket- " + this.socketCntr;
                        if (JSS_SelfServServer.this.bVerbose) {
                            System.out.println("ServerSSLSocket-" + this.socketCntr + ": Received " + inputLine);
                            System.out.println("Sending" + outputLine);
                        }
                        out.println(outputLine);
                        out.flush();
                    }
                    if (JSS_SelfServServer.this.bVerbose) {
                        System.out.println("ServerSSLSocket-" + this.socketCntr + " read null aborting connection.");
                    }
                }
                catch (SocketTimeoutException ste) {
                    System.out.println("ServerSSLSocket-" + this.socketCntr + " timed out: " + ste.toString());
                }
                catch (IOException ex) {
                    // empty catch block
                }
                is.close();
                os.close();
                this.socket.close();
                if (JSS_SelfServServer.this.bVerbose) {
                    System.out.println("ServerSSLSocket " + this.socketCntr + " has been Closed.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

