/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.tests.DSATestValues;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.tests.RSATestValues;
import org.mozilla.jss.tests.TestValues;

public class KeyFactoryTest {
    public static void main(String[] argv) {
        try {
            if (argv.length < 2) {
                System.out.println("Usage: java org.mozilla.jss.tests.KeyFactoryTest <dbdir> <passwordFile>");
                System.exit(1);
            }
            CryptoManager.initialize(argv[0]);
            CryptoToken tok = CryptoManager.getInstance().getInternalKeyStorageToken();
            FilePasswordCallback cb = new FilePasswordCallback(argv[1]);
            tok.login(cb);
            new KeyFactoryTest().doTest();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public void doTest() throws Throwable {
        String javaVendor = System.getProperty("java.vendor");
        RSATestValues rsa = null;
        DSATestValues dsa = null;
        boolean exception = false;
        if (javaVendor.equals("IBM Corporation")) {
            rsa = new RSATestValues("IBMJCE");
            dsa = new DSATestValues("IBMJCE");
        } else {
            rsa = new RSATestValues();
            dsa = new DSATestValues();
        }
        try {
            this.genPrivKeyFromSpec(rsa);
        }
        catch (InvalidKeySpecException ex) {
            if (javaVendor.equals("IBM Corporation")) {
                System.out.println("Could not generated a RSA private key from a\njava.security.spec.RSAPrivateKeySpec. Not supported IBMJCE");
            } else {
                exception = true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.genPrivKeyFromSpec(dsa);
        }
        catch (InvalidKeySpecException ex) {
            exception = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.genPubKeyFromSpec(rsa);
        }
        catch (Exception ex) {
            exception = true;
        }
        try {
            this.genPubKeyFromSpec(dsa);
        }
        catch (Exception ex) {
            exception = true;
        }
        if (exception) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    void genPrivKeyFromSpec(TestValues vals) throws Throwable {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(vals.keyGenAlg, vals.provider);
        kpg.initialize(512);
        KeyPair pair = kpg.generateKeyPair();
        KeyFactory sunFact = KeyFactory.getInstance(vals.keyGenAlg, vals.provider);
        Object keySpec = sunFact.getKeySpec(pair.getPrivate(), vals.privateKeySpecClass);
        KeyFactory jssFact = KeyFactory.getInstance(vals.keyGenAlg, "Mozilla-JSS");
        PrivateKey jssPrivk = jssFact.generatePrivate((KeySpec)keySpec);
        this.signVerify(vals.sigAlg, jssPrivk, "Mozilla-JSS", pair.getPublic(), vals.provider);
        System.out.println("Successfully generated a " + vals.keyGenAlg + " private key from a " + vals.privateKeySpecClass.getName());
    }

    public void signVerify(String sigAlg, PrivateKey privk, String signProv, PublicKey pubk, String verifyProv) throws Throwable {
        Signature signSig = Signature.getInstance(sigAlg, signProv);
        signSig.initSign(privk);
        String toBeSigned = "blah blah blah sign me";
        signSig.update(toBeSigned.getBytes("UTF-8"));
        byte[] signature = signSig.sign();
        Signature verSig = Signature.getInstance(sigAlg, verifyProv);
        verSig.initVerify(pubk);
        verSig.update(toBeSigned.getBytes("UTF-8"));
        if (!verSig.verify(signature)) {
            throw new Exception("Private/public key mismatch: signing alg=" + sigAlg + ", signing provider=" + signProv + ", verifying provider = " + verifyProv);
        }
    }

    void genPubKeyFromSpec(TestValues vals) throws Throwable {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(vals.keyGenAlg, vals.provider);
        kpg.initialize(512);
        KeyPair pair = kpg.generateKeyPair();
        KeyFactory sunFact = KeyFactory.getInstance(vals.keyGenAlg, vals.provider);
        Object keySpec = sunFact.getKeySpec(pair.getPublic(), vals.publicKeySpecClass);
        KeyFactory jssFact = KeyFactory.getInstance(vals.keyGenAlg, "Mozilla-JSS");
        PublicKey jssPubk = jssFact.generatePublic((KeySpec)keySpec);
        this.signVerify(vals.sigAlg, pair.getPrivate(), vals.provider, jssPubk, "Mozilla-JSS");
        System.out.println("Successfully generated a " + vals.keyGenAlg + " public key from a " + vals.publicKeySpecClass.getName());
    }
}

