/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;

public class KeyWrapping {
    public static void main(String[] args) {
        try {
            CryptoManager.initialize(".");
            CryptoManager cm = CryptoManager.getInstance();
            CryptoToken token = cm.getInternalCryptoToken();
            CryptoToken keyToken = cm.getInternalKeyStorageToken();
            KeyGenerator kg = token.getKeyGenerator(KeyGenAlgorithm.DES);
            KeyGenerator keyKg = keyToken.getKeyGenerator(KeyGenAlgorithm.DES3);
            SymmetricKey wrapped = kg.generate();
            SymmetricKey wrapper = kg.generate();
            SymmetricKey keyWrapper = keyKg.generate();
            SymmetricKey keyWrapped = keyKg.clone(wrapped);
            byte[] plaintextPre = new byte[]{115, 36, 81, 72, 50, -121, 35, 51, 101};
            byte[] plaintext = Cipher.pad(plaintextPre, EncryptionAlgorithm.DES_ECB.getBlockSize());
            System.out.println("plaintext length is " + plaintext.length);
            Cipher encryptor = token.getCipherContext(EncryptionAlgorithm.DES_ECB);
            encryptor.initEncrypt(wrapped);
            byte[] ciphertext = encryptor.doFinal(plaintext);
            System.out.println("ciphertext length is " + ciphertext.length);
            KeyWrapper keyWrap = token.getKeyWrapper(KeyWrapAlgorithm.DES_ECB);
            keyWrap.initWrap(wrapper, null);
            byte[] wrappedKey = keyWrap.wrap(wrapped);
            keyWrap.initUnwrap(wrapper, null);
            SymmetricKey unwrapped = keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.DES, SymmetricKey.Usage.DECRYPT, 0);
            Cipher decryptor = token.getCipherContext(EncryptionAlgorithm.DES_ECB);
            decryptor.initDecrypt(unwrapped);
            byte[] recoveredPre = decryptor.doFinal(ciphertext);
            System.out.println("Decrypted " + recoveredPre.length + " bytes");
            byte[] recovered = Cipher.unPad(recoveredPre, EncryptionAlgorithm.DES_ECB.getBlockSize());
            System.out.println("plaintext:");
            KeyWrapping.displayByteArray(plaintextPre);
            System.out.println("ciphertext:");
            KeyWrapping.displayByteArray(ciphertext);
            System.out.println("recovered:");
            KeyWrapping.displayByteArray(recovered);
            keyWrap = keyToken.getKeyWrapper(KeyWrapAlgorithm.DES3_CBC_PAD);
            IVParameterSpec iv = new IVParameterSpec(recovered);
            keyWrap.initWrap(keyWrapper, (AlgorithmParameterSpec)iv);
            KeyPairGenerator kpg = keyToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            kpg.initialize(512);
            kpg.temporaryPairs(true);
            KeyPair kp = kpg.genKeyPair();
            PublicKey pub = kp.getPublic();
            PrivateKey privk = (PrivateKey)kp.getPrivate();
            wrappedKey = keyWrap.wrap(privk);
            System.out.println("Original key:");
            KeyWrapping.displayByteArray(privk.getUniqueID());
            privk = null;
            kp = null;
            keyWrap.initUnwrap(keyWrapper, (AlgorithmParameterSpec)iv);
            PrivateKey newPrivk = keyWrap.unwrapTemporaryPrivate(wrappedKey, PrivateKey.RSA, pub);
            System.out.println("New key:");
            KeyWrapping.displayByteArray(newPrivk.getUniqueID());
            keyWrap = keyToken.getKeyWrapper(KeyWrapAlgorithm.RSA);
            keyWrap.initWrap(pub, null);
            wrappedKey = keyWrap.wrap(keyWrapped);
            keyWrap.initUnwrap(newPrivk, null);
            unwrapped = keyWrap.unwrapSymmetric(wrappedKey, SymmetricKey.DES, SymmetricKey.Usage.DECRYPT, 0);
            unwrapped = kg.clone(unwrapped);
            decryptor = token.getCipherContext(EncryptionAlgorithm.DES_ECB);
            decryptor.initDecrypt(unwrapped);
            recovered = decryptor.doFinal(ciphertext);
            System.out.println("Recovered again:");
            KeyWrapping.displayByteArray(Cipher.unPad(recovered, 8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void displayByteArray(byte[] ba) {
        for (int i = 0; i < ba.length; ++i) {
            System.out.print(Integer.toHexString(ba[i] & 0xFF) + " ");
            if (i % 26 != 25) continue;
            System.out.println("");
        }
        System.out.println("");
    }
}

