/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Password;

public class PK10Gen {
    public static void main(String[] args) {
        Password pass1 = null;
        Password pass2 = null;
        char[] passchar1 = new char[]{'f', 'o', 'o', 'b', 'a', 'r'};
        char[] passchar2 = new char[]{'n', 'e', 't', 's', 'c', 'a', 'p', 'e'};
        if (args.length != 2) {
            System.err.println("Usage: java org.mozilla.jss.PK10Gen <dbdir> [rsa|dsa]");
            return;
        }
        try {
            CryptoManager manager;
            CryptoManager.initialize(args[0]);
            try {
                manager = CryptoManager.getInstance();
            }
            catch (CryptoManager.NotInitializedException e) {
                System.out.println("CryptoManager not initialized");
                return;
            }
            PK11Token token = (PK11Token)manager.getInternalKeyStorageToken();
            if (!token.isLoggedIn()) {
                System.out.println("Good, isLoggedIn correctly says we're not logged in");
            } else {
                System.out.println("ERROR: isLoggedIn incorrectly says we're logged in");
            }
            pass1 = new Password((char[])passchar1.clone());
            pass2 = new Password(new char[]{'\u0000'});
            token.initPassword(pass2, pass1);
            pass1.clear();
            pass2.clear();
            System.out.println("initialized PIN");
            token.login(pass1);
            System.out.println("logged in");
            String blob = token.generateCertRequest("cn=christina Fu", 512, args[1], null, null, null);
            System.out.println("pkcs#10 blob = \n" + blob);
        }
        catch (Exception e) {
            System.out.println("exception caught in PK10Gen: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

