/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PBEKeyGenParams;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.pkcs11.PK11SecureRandom;
import org.mozilla.jss.util.Password;

public class SymKeyGen {
    private CryptoToken token = null;
    byte[] plainText16Bytes = "Firefox   rules!".getBytes();
    byte[] plainText18Bytes = "Thunderbird rules!".getBytes();

    public SymmetricKey genPBEKey(PBEAlgorithm alg2, SymmetricKey.Type keyType, int keyStrength) throws Exception {
        SymmetricKey key = null;
        KeyGenerator kg = this.token.getKeyGenerator(alg2);
        try {
            kg.initialize(keyStrength);
            throw new Exception("ERROR: Initializing PBE key with strength " + keyStrength + " succeeded");
        }
        catch (InvalidAlgorithmParameterException e) {
            Password pass = new Password("passwd1".toCharArray());
            byte[] salt = this.genSalt(alg2.getSaltLength());
            PBEKeyGenParams kgp = new PBEKeyGenParams(pass, salt, 2);
            pass.clear();
            kg.initialize(kgp);
            key = kg.generate();
            kgp.clear();
            if (key.getType() != keyType) {
                throw new Exception("Wrong key type: " + key.getType());
            }
            if (!((Object)key.getOwningToken()).equals(this.token)) {
                throw new Exception("wrong token");
            }
            if (key.getStrength() != keyStrength) {
                throw new Exception("wrong strength: " + key.getStrength());
            }
            return key;
        }
    }

    public SymmetricKey genPBAKey(KeyGenAlgorithm alg2, SymmetricKey.Type keyType, int keyStrength) throws Exception {
        SymmetricKey key = null;
        KeyGenerator kg = this.token.getKeyGenerator(alg2);
        try {
            kg.initialize(keyStrength);
            throw new Exception("ERROR: Initializing PBE key with strength " + keyStrength + " succeeded");
        }
        catch (InvalidAlgorithmParameterException e) {
            Password pass = new Password("passwd1".toCharArray());
            byte[] salt = this.genSalt(8);
            PBEKeyGenParams kgp = new PBEKeyGenParams(pass, salt, 2);
            pass.clear();
            kg.initialize(kgp);
            key = kg.generate();
            kgp.clear();
            if (key.getType() != keyType) {
                throw new Exception("Wrong key type: " + key.getType());
            }
            if (!((Object)key.getOwningToken()).equals(this.token)) {
                throw new Exception("wrong token");
            }
            if (key.getStrength() != keyStrength) {
                throw new Exception("wrong strength: " + key.getStrength());
            }
            return key;
        }
    }

    public SymmetricKey genSymKey(KeyGenAlgorithm alg2, SymmetricKey.Type keyType, int keyStrength, int keyLength) throws Exception {
        SymmetricKey key = null;
        KeyGenerator kg = this.token.getKeyGenerator(alg2);
        if (alg2 == KeyGenAlgorithm.AES || alg2 == KeyGenAlgorithm.RC4 || alg2 == KeyGenAlgorithm.RC2) {
            kg.initialize(keyStrength);
        }
        if ((key = kg.generate()).getType() != keyType) {
            throw new Exception("wrong algorithm");
        }
        if (!((Object)key.getOwningToken()).equals(this.token)) {
            throw new Exception("wrong token");
        }
        if (key.getStrength() != keyStrength) {
            throw new Exception("wrong strength");
        }
        byte[] keyData = key.getKeyData();
        if (keyData.length != keyLength) {
            throw new Exception("key data wrong length: " + keyData.length);
        }
        return key;
    }

    public boolean cipherTest(SymmetricKey key, EncryptionAlgorithm eAlg) throws Exception {
        boolean bStatus = false;
        int ivLength = 0;
        AlgorithmParameterSpec algParSpec = null;
        Cipher cipher2 = null;
        cipher2 = this.token.getCipherContext(eAlg);
        byte[] plaintext = this.plainText18Bytes;
        if ((eAlg.getMode() == EncryptionAlgorithm.Mode.CBC || eAlg.getMode() == EncryptionAlgorithm.Mode.ECB) && eAlg.getPadding() == EncryptionAlgorithm.Padding.NONE) {
            plaintext = this.plainText16Bytes;
        }
        if ((ivLength = eAlg.getIVLength()) != 0) {
            algParSpec = this.genIV(ivLength);
        }
        if (key.getType() == SymmetricKey.RC2) {
            byte[] iv = new byte[ivLength];
            PK11SecureRandom rng = new PK11SecureRandom();
            rng.nextBytes(iv);
            algParSpec = new RC2ParameterSpec(40, iv);
        }
        if (algParSpec == null) {
            cipher2.initEncrypt(key);
        } else {
            cipher2.initEncrypt(key, algParSpec);
        }
        byte[] ciphertext = cipher2.doFinal(plaintext);
        if (ivLength == 0) {
            cipher2.initDecrypt(key);
        } else {
            cipher2.initDecrypt(key, algParSpec);
        }
        byte[] recovered = cipher2.doFinal(ciphertext);
        if (recovered.length != plaintext.length) {
            throw new Exception("Recovered plaintext has different length (" + recovered.length + ") than original (" + plaintext.length + ")");
        }
        if (!Arrays.equals(plaintext, recovered)) {
            throw new Exception("ERROR: unable to recover plaintext");
        }
        bStatus = true;
        return bStatus;
    }

    private SymKeyGen(String certDbLoc) {
        try {
            CryptoManager.initialize(certDbLoc);
            CryptoManager cm = CryptoManager.getInstance();
            this.token = cm.getInternalCryptoToken();
        }
        catch (AlreadyInitializedException ex) {
            ex.printStackTrace();
        }
        catch (CertDatabaseException ex) {
            ex.printStackTrace();
        }
        catch (CryptoManager.NotInitializedException ex) {
            ex.printStackTrace();
        }
        catch (GeneralSecurityException ex) {
            ex.printStackTrace();
        }
        catch (KeyDatabaseException ex) {
            ex.printStackTrace();
        }
    }

    public IVParameterSpec genIV(int blockSize) throws Exception {
        byte[] iv = new byte[blockSize];
        PK11SecureRandom rng = new PK11SecureRandom();
        rng.nextBytes(iv);
        return new IVParameterSpec(iv);
    }

    public byte[] genSalt(int saltSize) throws Exception {
        byte[] salt = new byte[saltSize];
        PK11SecureRandom rng = new PK11SecureRandom();
        rng.nextBytes(salt);
        return salt;
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println("Usage: java org.mozilla.jss.tests.SymKeyGen <dbdir>");
                System.exit(1);
            }
            SymKeyGen skg = new SymKeyGen(args[0]);
            SymmetricKey key = null;
            key = skg.genSymKey(KeyGenAlgorithm.DES, SymmetricKey.DES, 56, 8);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC_PAD);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.DES_ECB);
            System.out.println("DES key and cipher tests correct");
            key = skg.genSymKey(KeyGenAlgorithm.DES3, SymmetricKey.DES3, 168, 24);
            skg.cipherTest(key, EncryptionAlgorithm.DES3_CBC_PAD);
            skg.cipherTest(key, EncryptionAlgorithm.DES3_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.DES3_ECB);
            System.out.println("DESede key and cipher tests correct");
            key = skg.genSymKey(KeyGenAlgorithm.AES, SymmetricKey.AES, 128, 16);
            skg.cipherTest(key, EncryptionAlgorithm.AES_128_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.AES_128_ECB);
            skg.cipherTest(key, EncryptionAlgorithm.AES_128_CBC_PAD);
            System.out.println("AES 128 key and cipher tests correct");
            key = skg.genSymKey(KeyGenAlgorithm.AES, SymmetricKey.AES, 192, 24);
            skg.cipherTest(key, EncryptionAlgorithm.AES_192_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.AES_192_ECB);
            skg.cipherTest(key, EncryptionAlgorithm.AES_192_CBC_PAD);
            System.out.println("AES 192 key and cipher tests correct");
            key = skg.genSymKey(KeyGenAlgorithm.AES, SymmetricKey.AES, 256, 32);
            skg.cipherTest(key, EncryptionAlgorithm.AES_256_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.AES_256_ECB);
            skg.cipherTest(key, EncryptionAlgorithm.AES_256_CBC_PAD);
            System.out.println("AES 256 key and cipher tests correct");
            key = skg.genSymKey(KeyGenAlgorithm.RC2, SymmetricKey.RC2, 40, 5);
            skg.cipherTest(key, EncryptionAlgorithm.RC2_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.RC2_CBC_PAD);
            System.out.println("RC2 key and cipher tests correct");
            key = skg.genSymKey(KeyGenAlgorithm.RC4, SymmetricKey.RC4, 128, 16);
            skg.cipherTest(key, EncryptionAlgorithm.RC4);
            System.out.println("RC4 key and cipher tests correct");
            key = skg.genPBEKey(PBEAlgorithm.PBE_MD2_DES_CBC, SymmetricKey.DES, 56);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC_PAD);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.DES_ECB);
            key = skg.genPBEKey(PBEAlgorithm.PBE_MD5_DES_CBC, SymmetricKey.DES, 56);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC_PAD);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.DES_ECB);
            key = skg.genPBEKey(PBEAlgorithm.PBE_SHA1_DES_CBC, SymmetricKey.DES, 64);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC_PAD);
            skg.cipherTest(key, EncryptionAlgorithm.DES_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.DES_ECB);
            key = skg.genPBEKey(PBEAlgorithm.PBE_SHA1_DES3_CBC, SymmetricKey.DES3, 168);
            skg.cipherTest(key, EncryptionAlgorithm.DES3_CBC_PAD);
            skg.cipherTest(key, EncryptionAlgorithm.DES3_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.DES3_ECB);
            key = skg.genPBEKey(PBEAlgorithm.PBE_SHA1_RC2_40_CBC, SymmetricKey.RC2, 40);
            skg.cipherTest(key, EncryptionAlgorithm.RC2_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.RC2_CBC_PAD);
            key = skg.genPBEKey(PBEAlgorithm.PBE_SHA1_RC2_128_CBC, SymmetricKey.RC2, 128);
            skg.cipherTest(key, EncryptionAlgorithm.RC2_CBC);
            skg.cipherTest(key, EncryptionAlgorithm.RC2_CBC_PAD);
            key = skg.genPBEKey(PBEAlgorithm.PBE_SHA1_RC4_40, SymmetricKey.RC4, 40);
            skg.cipherTest(key, EncryptionAlgorithm.RC4);
            key = skg.genPBEKey(PBEAlgorithm.PBE_SHA1_RC4_128, SymmetricKey.RC4, 128);
            skg.cipherTest(key, EncryptionAlgorithm.RC4);
            System.out.println("Password Based key generation tests correct");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class alg {
        public KeyGenAlgorithm sAlg;
        public SymmetricKey.Type keyType;
        public int size;
        public int blkSize;
        List ciphers = new LinkedList();

        public alg(KeyGenAlgorithm alg2, SymmetricKey.Type kType, int sz, int bSize) {
            this.sAlg = alg2;
            this.keyType = kType;
            this.size = sz;
            this.blkSize = bSize;
        }

        public void setEncAlgs(List c) {
            this.ciphers = c;
        }
    }
}

