/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class TestCertificateApprovalCallback
implements SSLCertificateApprovalCallback {
    public boolean approve(X509Certificate servercert, SSLCertificateApprovalCallback.ValidityStatus status) {
        boolean trust_the_server_cert = false;
        Enumeration errors = status.getReasons();
        int i = 0;
        while (errors.hasMoreElements()) {
            ++i;
            SSLCertificateApprovalCallback.ValidityItem item = (SSLCertificateApprovalCallback.ValidityItem)errors.nextElement();
            PK11Cert cert = item.getCert();
            if (item.getReason() != -8172) continue;
            trust_the_server_cert = true;
        }
        if (trust_the_server_cert) {
            try {
                InternalCertificate newcert = CryptoManager.getInstance().importCertToPerm(servercert, "testnick");
                newcert.setSSLTrust(3);
            }
            catch (Exception e) {
                System.out.println("thrown exception: " + e);
            }
        }
        return true;
    }
}

